<?php

namespace App\Http\Controllers\Owner\StatusGroup;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroup\Application\Delete\DeleteStatusGroupQuery;
use App\Modules\StatusGroup\Application\Delete\DeleteStatusGroupQueryResponse;

class StatusGroupDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::STATUS_GROUP);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        /** @var DeleteStatusGroupQueryResponse $response */
        $response = $this->queryBus->ask(new DeleteStatusGroupQuery($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response->response());
    }
}
