<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ReviewNotification\Application\List\ReviewNotificationListerQuery;
use App\Modules\ReviewNotification\Application\List\ReviewNotificationListerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($IdGroupPassenger, $Action)
    {
        /** @var ReviewNotificationListerResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationListerQuery($IdGroupPassenger, $Action));
        
        return ResponseBuilder::Response($response->response());
    }
}
