<?php

namespace App\Http\Controllers\Owner\QuestionTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\QuestionTypeProvider\Application\Update\QuestionTypeProviderUpdaterQuery;
use App\Modules\QuestionTypeProvider\Application\Update\QuestionTypeProviderUpdaterResponse;
use App\Modules\QuestionTypeProvider\Infraestructure\QuestionTypeProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class QuestionTypeProviderUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "QuestionTypeProvider";
        $this->history = new HistoryData(HistoryTables::QUESTION_TYPE_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, QuestionTypeProviderValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_QuestionTypeProvider"));

        /** @var QuestionTypeProviderUpdaterResponse $response */
        $response = $this->queryBus->ask(
            new QuestionTypeProviderUpdaterQuery(
                $request->input('Id_QuestionTypeProvider'),
                $request->input('QuestionTypeProvider_Show'),
                $request->input('QuestionTypeProvider_ForPassenger'),
                $request->input('QuestionTypeProvider_Status'),
                $request->input('Id_Question'),
                $request->input('Id_TypeProvider')
            )
        );

        $this->history->updateBasic($request->input("Id_QuestionTypeProvider"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
