<?php
namespace App\Http\Controllers\Owner\ProviderTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ProviderTypeProvider\Application\List\ProviderTypeProviderListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderTypeProviderListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($IdProvider, $Action)
    {
        /** @var ProviderTypeProviderListerResponse $response */
        $response = $this->queryBus->ask(new ProviderTypeProviderListerQuery($IdProvider, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
