<?php

namespace App\Http\Controllers\Owner\ProviderTypeProvider;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ProviderTypeProvider\Application\Create\ProviderTypeProviderInserterQuery;
use App\Modules\ProviderTypeProvider\Application\Create\ProviderTypeProviderInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ProviderTypeProvider\Infraestructure\ProviderTypeProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderTypeProviderInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ProviderTypeProvider";
        $this->history = new HistoryData(HistoryTables::PROVIDER_TYPE_PROVIDER);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ProviderTypeProviderValidators::INSERT);

        /** @var ProviderTypeProviderInserterResponse $response */
        $response = $this->queryBus->ask(
            new ProviderTypeProviderInserterQuery(
                $request->input('ProviderTypeProvider_Status'),
                $request->input('Id_Provider'),
                $request->input('Id_TypeProvider')
            )
        );
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
