<?php

namespace App\Http\Controllers\Owner\ProviderSanction;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ProviderSanction\Application\Create\ProviderSanctionInserterQuery;
use App\Modules\ProviderSanction\Application\Create\ProviderSanctionInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ProviderSanction\Infraestructure\ProviderSanctionValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ProviderSanctionInsertController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "ProviderSanction";
        $this->history = new HistoryData(HistoryTables::PROVIDER_SANCTION);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ProviderSanctionValidators::INSERT);
        /** @var ProviderSanctionInserterResponse $response */
        $response = $this->queryBus->ask(new ProviderSanctionInserterQuery(
            $request->input('ProviderSanction_Remark'),
            $request->input('ProviderSanction_DateStart'),
            $request->input('ProviderSanction_DateEnd'),
            $request->input('ProviderSanction_Status'),
            $request->input('Id_Provider'),
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
