<?php

namespace App\Http\Controllers\Owner\Provider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProviderListScoreController extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Provider";
    }


    public function __invoke(Request $Request, $Id)
    {
        $validations = [
            'DateStart'             => 'required|string|date',
            'DateEnd'               => 'required|string|date'
        ];
        (new LaravelValidator())->validate($Request->all(), $this->oDomain, $validations);
        $oResponse  = array();
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Id,
                $Request->input('DateStart'),
                $Request->input('DateEnd')
            ];
            $oData  = DB::select('call sp_provider_list_score(?,?,?)', $oParam);
            $oParam = [
                $Id,
                $Request->input('DateStart') . ' 00:00:00',
                $Request->input('DateEnd') . ' 23:59:59'
            ];
            $externalReviewScore  = DB::select('call sp_internal_provider_external_review_score(?,?,?,@sts,@cod,@msg)', $oParam);
            $passengerReviewScore  = DB::select('call sp_internal_provider_passenger_review_score(?,?,?,@sts,@cod,@msg)', $oParam);
            $groupData  = DB::select('call sp_internal_provider_group_passenger_count(?,?,?,@sts,@cod,@msg)', $oParam);

            $oData = $this->indexProvider($oData, $externalReviewScore, $passengerReviewScore, $groupData);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " list " . $Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function indexProvider($providerListScore, $externalReviewScore, $passengerReviewScore, $groupData)
    {
        $map = array_reduce($providerListScore, [$this, 'addProviderIntoProviderMap'], new ProviderMap());
        $map = array_reduce($externalReviewScore, [$this, 'appendExternalReviewIntoProviderMap'], $map);
        $map = array_reduce($passengerReviewScore, [$this, 'appendPassengerReviewIntoProviderMap'], $map);
        $map = array_reduce($groupData, [$this, 'appendGroupIntoProviderMap'], $map);
        return $map->values();
    }

    public function addProviderIntoProviderMap(ProviderMap $providerMap, $provider)
    {
        $providerMap->add($provider->Id_Provider, $provider);
        return $providerMap;
    }

    public function appendExternalReviewIntoProviderMap(ProviderMap $providerMap, $externalReviewScore)
    {
        $score = json_decode($externalReviewScore->Score);
        $providerMap->appendAttribute(
            $externalReviewScore->Id_Provider,
            'ExternalReview',
            $score[0]->Id_External === null ? '[]' : $externalReviewScore->Score
        );
        return $providerMap;
    }

    public function appendPassengerReviewIntoProviderMap(ProviderMap $providerMap, $passengerReviewScore)
    {
        $score = json_decode($passengerReviewScore->Score);
        $providerMap->appendAttribute(
            $passengerReviewScore->Id_Provider,
            'PassengerReview',
            $score[0]->PassengerReview_Score === null ? '[]' : $passengerReviewScore->Score
        );
        return $providerMap;
    }

    public function appendGroupIntoProviderMap(ProviderMap $providerMap, $groupData)
    {
        $score = json_decode($groupData->Score);
        $providerMap->appendAttribute(
            $groupData->Id_Provider,
            'GroupData',
            $score->Group_Amount === null ? '{"Group_Amount":0, "GroupPassenger_Amount":0}' : $groupData->Score
        );
        return $providerMap;
    }
}
