<?php
namespace App\Http\Controllers\Owner\PassengerReview;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\PassengerReview\Application\PassengerReviewRestore;
use App\Modules\PassengerReview\Infraestructure\MysqlPassengerReviewRestoreRepository;

final class Restore extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'PassengerReview';
    }

    public function __invoke(int $Id_PassengerReview)
    {
        $response = (new PassengerReviewRestore(new MysqlPassengerReviewRestoreRepository))($Id_PassengerReview);
        return ResponseBuilder::Response($response);
    }
}
