<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Controllers\Owner\c_Passenger;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Passenger\Application\PassengerUpdateDocuments;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Passenger\Domain\PassengerImageDocument1;
use App\Modules\Passenger\Domain\PassengerImageDocument2;
use App\Modules\Passenger\Infraestructure\MysqlPassengerRepository;
use App\Modules\Passenger\Infraestructure\PassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class PassengerUpdateDocumentsController
{
    private string $domain;
    private HistoryData $history;
    public function __construct(
        private QueryBus $queryBus,
        private PassengerUpdater $passengerUpdater
    ) {
        $this->domain = 'Passenger';
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate(
            $request->all(),
            $this->domain,
            PassengerValidators::getUpdateDocuments(config("var.MIME_IMG"))
        );

        $this->history->obtainOld($request->input('Id_Passenger'), '', '', '', '');

        $upload1 = $this->uploadImage(1, $request);
        $upload2 = $this->uploadImage(2, $request);

        $data = (new PassengerUpdateDocuments(new MysqlPassengerRepository))
            ->__invoke(
                new IdPassenger($request->input('Id_Passenger')),
                new PassengerImageDocument1($upload1['Image_Name']),
                new PassengerImageDocument2($upload2['Image_Name']),
            );
        $response = [
            "Response_Status"           => $data[0]->Response_Status,
            "Response_Code"             => $data[0]->Response_Code,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => $data[0]->Response_Message,
            "Response_Data"             => [],
            "Response_Error_Message"    => $data[0]->Response_Message,
            "Response_Error_Reason"     => $data[0]->Response_Reason,
        ];
        return ResponseBuilder::Response($response);
    }

    private function uploadImage(int $type, Request $request)
    {
        $uploadResponse = (new c_Passenger($this->queryBus, $this->passengerUpdater))->Image_Upload($type, $request);
        if ($uploadResponse['RespCode'] != 200) {
            throw new InvalidRequestException($this->toResponse($uploadResponse, $this->domain));
        }
        return $uploadResponse;
    }

    private function toResponse($uploadResponse, $domain)
    {
        return [
            "Response_Status"           => $uploadResponse["RespCode"],
            "Response_Code"             => $uploadResponse["RespCode"],
            "Response_Domain"           => $domain,
            "Response_Message"          => $uploadResponse["RespMessage"],
            "Response_Data"             => null,
            "Response_Error_Message"    => $uploadResponse["RespMessage"],
            "Response_Error_Reason"     => $uploadResponse["ErReason"],
        ];
    }
}
