<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Passenger\Application\Confirm\ConfirmPassengerQuery;
use App\Modules\Passenger\Application\Confirm\ConfirmPassengerResponse;
use App\Modules\Passenger\Infraestructure\PassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class PassengerConfirmController
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Passenger";
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public function __invoke($Id, Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, PassengerValidators::UPDATE_CONFIRM);

        $this->history->obtainOld($Id);

        /** @var ConfirmPassengerResponse $response */
        $response = $this->queryBus->ask(new ConfirmPassengerQuery(
            $Id,
            $request->input('Passenger_ConfirmMessage', '')
        ));

        $this->history->updateBasic($Id, $request);
        return ResponseBuilder::Response($response->response());
    }
}
