<?php

namespace App\Http\Controllers\Owner\Machupicchu;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Machupicchu\Application\AvailabilityList\MachupicchuAvailabilityListerQuery;
use App\Modules\Machupicchu\Infraestructure\MachupicchuAvailabilityValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class MachupicchuAvailabilityListController extends Controller
{
    private string $oDomain;
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->oDomain = 'MachupicchuAvailability';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate(
            $request->all(),
            $this->oDomain,
            MachupicchuAvailabilityValidators::AVAILABILITY_LIST
        );

        /** @var MachupicchuAvailabilityListerResponse $response */
        $response = $this->queryBus->ask(new MachupicchuAvailabilityListerQuery(
            $request->input('MachupicchuAvailability_Year'),
            $request->input('MachupicchuAvailability_IdRoute'),
            $request->input('MachupicchuAvailability_Month'),
        ));

        return ResponseBuilder::Response($response->response());
    }
}
