<?php
namespace App\Http\Controllers\Owner\LeadBookingTour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingTour\Application\Delete\LeadBookingTourDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingTour";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING_TOUR);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadBookingTourDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
