<?php
namespace App\Http\Controllers\Owner\LeadBookingService;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\LeadBookingService\Application\Delete\LeadBookingServiceDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingServiceDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBookingService";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadBookingServiceDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingServiceDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
