<?php
namespace App\Http\Controllers\Owner\LeadBooking;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBooking\Application\Index\LeadBookingIndexerQuery;
use App\Modules\LeadBooking\Application\Index\LeadBookingIndexerResponse;
use App\Modules\LeadBookingTour\Application\List\LeadBookingTourListerQuery;
use App\Modules\LeadBookingTour\Application\List\LeadBookingTourListerResponse;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerQuery;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingIndexController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var LeadBookingIndexerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingIndexerQuery($Id));
        $booking = $response->response()['Response_Data'][0];
        $idLeadBooking = $booking->Id_LeadBooking;

        /** @var LeadPassengerListerResponse $passengers */
        $passengers = $this->queryBus->ask(new LeadPassengerListerQuery($idLeadBooking, 'all'));

        /** @var LeadBookingTourListerResponse $bookingTours */
        $bookingTours = $this->queryBus->ask(new LeadBookingTourListerQuery($idLeadBooking, 'all'));

        $booking->LeadPassenger = ($passengers->response())['Response_Data'];
        $booking->BookingTour = ($bookingTours->response())['Response_Data'];

        return ResponseBuilder::Response($response->response());
    }
}
