<?php

namespace App\Http\Controllers\Owner\Info;

use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\HtlCampBooking\Application\UpdateDateStart\UpdateDateStartHtlCampBookingQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateUtils;
use Illuminate\Support\Facades\DB;

class Migration90Controller
{
    private $htlCampBooking = [];
    private $htlCampSchedule = [];
    private $tourHtlCamp = [];
    private $bookings = [];
    public function __construct(
        private QueryBus $queryBus,
        private PassengerUpdater $passengerUpdater
    ) {
    }

    private function getHtlCampBookings()
    {
        return DB::select('SELECT *
            FROM t_passenger');
    }

    private function getBookingTourPassenger()
    {
        return DB::select('SELECT `btp`.*,
            `bt`.`Id_Tour`,
            `bt`.`BookingTour_DateStart`
            FROM `t_booking_tour_passenger` `btp`
            INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_BookingTour` = `btp`.`Id_BookingTour`
            ');
    }

    private function getTourHtlCampList($idTour)
    {
        if (isset($this->tourHtlCamp[$idTour])) {
            return $this->tourHtlCamp[$idTour];
        }
        $this->tourHtlCamp[$idTour] = DB::select(
            'SELECT *
            FROM `t_tour_htl_camp`
            WHERE `Id_Tour`=?',
            [$idTour]
        );
        return $this->tourHtlCamp[$idTour];
    }

    private function getHtlCampBookingList($idBookingTour)
    {
        if (isset($this->htlCampBooking[$idBookingTour])) {
            return $this->htlCampBooking[$idBookingTour];
        }
        $this->htlCampBooking[$idBookingTour] = DB::select(
            'SELECT `hcb`.*, `hcs`.`Id_HtlCamp`
            FROM `t_htl_camp_booking` `hcb`
            INNER JOIN `t_htl_camp_schedule` `hcs` ON `hcs`.`Id_HtlCampSchedule` = `hcb`.`Id_HtlCampSchedule`
            WHERE `HtlCampBooking_Lock` = 2
            AND `Id_BookingTour` = ?',
            [$idBookingTour]
        );
        return $this->htlCampBooking[$idBookingTour];
    }

    public function __invoke()
    {
        // $changed = array_merge([], $this->updatePassengers(0, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(10000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(20000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(30000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(40000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(50000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(60000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(70000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(80000, 10000));

        // $passengers = $this->getHtlCampBookings();

        // $this->updatePassengers(0, 10000, $passengers);
        // $this->updatePassengers(10000, 10000, $passengers);
        // $this->updatePassengers(20000, 10000, $passengers);
        // $this->updatePassengers(30000, 10000, $passengers);
        // $this->updatePassengers(40000, 10000, $passengers);
        // $this->updatePassengers(50000, 10000, $passengers);

        $btpList = $this->getBookingTourPassenger();
        $continued = 0;
        $modified = 0;
        foreach ($btpList as $btp) {
            $htlCampBookingList = $this->getHtlCampBookingList($btp->Id_BookingTour);
            $tourHtlCampList = $this->getTourHtlCampList($btp->Id_Tour);
            // $btp->BookingTour_DateStart
            foreach ($htlCampBookingList as $i => $hcb) {
                if (!isset($tourHtlCampList[$i])) {
                    dd($tourHtlCampList, $htlCampBookingList);
                    $continued++;
                    continue;
                }
                if ($hcb->Id_HtlCamp != $tourHtlCampList[$i]->Id_HtlCamp) {
                    // dd('continue');
                    $continued++;
                    continue;
                }
                $difference = DateUtils::dateDiferenceInDays(
                    date('Y-m-d', strtotime($hcb->HtlCampBooking_DateStart)),
                    $btp->BookingTour_DateStart,
                );
                if ($difference == $tourHtlCampList[$i]->TourHtlCamp_Day - 1) {
                } else {
                    $list = $this->queryBus->ask(new UpdateDateStartHtlCampBookingQuery(
                        $hcb->Id_HtlCampBooking,
                        DateUtils::changeDate($hcb->HtlCampBooking_DateStart, -$difference + $tourHtlCampList[$i]->TourHtlCamp_Day - 1) . ' 00:00:00'
                    ));
                    $htlCampBookingList[$i] = null;
                    $modified++;
                    // dd($btp, $difference, $tourHtlCampList[$i]->TourHtlCamp_Day - 1);
                }
                // if ($tourHtlCampList[$i]->Id_Tour == $hcb)
            }
        }

        dd($modified, $continued);
    }

    // private function updatePassengers($offset, $limit, &$passengers)
    // {
    //     $length = count($passengers);
    //     for ($i = $offset; $i < $offset + $limit; $i++) {
    //         if ($i >= $length) {
    //             return;
    //         }
    //         if (!isset($this->bookings[$passengers[$i]->Id_Booking])) {
    //             $this->bookings[$passengers[$i]->Id_Booking] = $this->getBookingIndex($passengers[$i]->Id_Booking);
    //         }

    //         $this->passengerUpdater->updateLockHtlCampBookingPassenger(
    //             $passengers[$i]->Id_Passenger,
    //             $this->bookings[$passengers[$i]->Id_Booking]
    //         );
    //     }
    // }

    // private function getBookingIndex($Id_Booking)
    // {
    //     return DB::select('CALL sp_booking_index(?)', [$Id_Booking])[0];
    // }
}
