<?php

namespace App\Http\Controllers\Owner\Info;

use App\Modules\PackageFee\Application\GetFull\PackageFeeGetFullQuery;
use App\Modules\PackageFee\Application\GetFull\PackageFeeGetFullQueryResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class Migration66Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
        
    }
    public function __invoke()
    {
        $bookingList = DB::select('SELECT `b`.`Id_Booking`, `b`.`Id_Admin`
        FROM `t_booking` `b`
        LEFT JOIN `t_booking_assign` `ba` ON `ba`.`Id_Booking` = `b`.`Id_Booking`
        WHERE `b`.`Id_Admin` <> 0
        AND `ba`.`Id_Booking` IS NULL
        AND `b`.`Booking_Status` > 0
        ORDER BY `b`.`Id_Booking`');

        $query = '';
        foreach ($bookingList as $booking) {
            $query .= 'CALL `sp_booking_assign_insert`(\'\', 2, ' . $booking->Id_Booking . ', ' . $booking->Id_Admin . ', 1, @sts, @cod, @msg, @id);' . "\n";
        }

        echo $query;

        $this->assignFee();
    }

    public function assignFee()
    {
        $btList = DB::select('SELECT `Id_BookingTour`, `Id_Package` FROM `t_booking_tour` ORDER BY `Id_BookingTour`');

        $query = '';
        foreach ($btList as $bt) {
            /** @var PackageFeeGetFullQueryResponse $response */
            $response = $this->queryBus->ask(new PackageFeeGetFullQuery($bt->Id_Package));
            $query .= "UPDATE `t_booking_tour` "
                . "SET `BookingTour_Full` = {$response->packageFeeTotal()}, "
                . "`BookingTour_MinimumFull` = {$response->packageFeeTotal()}, "
                . "`BookingTour_FeeType` = {$response->packageFeeType()} "
                . "WHERE `Id_BookingTour` = {$bt->Id_BookingTour};\n";
        }

        echo $query;
    }
}
