<?php
namespace App\Http\Controllers\Owner\HtlTypeRoom;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlTypeRoom\Application\HtlTypeRoomResponse;
use App\Modules\HtlTypeRoom\Application\Index\IndexHtlTypeRoomQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoom";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var HtlTypeRoomResponse $response */
        $response = $this->queryBus->ask(new IndexHtlTypeRoomQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ $response ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
