<?php
namespace App\Http\Controllers\Owner\HtlBed;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlBed\Application\HtlBedResponse;
use App\Modules\HtlBed\Application\Index\IndexHtlBedQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlBedIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlBed";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var HtlBedResponse $response */
        $response = $this->queryBus->ask(new IndexHtlBedQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ $response ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Cama encontrada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
