<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassenger\Application\Report\ReportGroupPassengerQuery;
use App\Modules\GroupPassenger\Application\Report\ReportGroupPassengerResponse;
use App\Modules\GroupPassenger\Infraestructure\GroupPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Providers\ExcelGroupPassengerReport\ExcelGroupPassengerReport;
use Illuminate\Http\Request;

final class GroupPassengerReviewExportToExcelController extends Controller
{
    private string $domain = 'GroupPassenger';

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $Request)
    {
        $oResponse = ParamsValidator::Validate_Request($Request, GroupPassengerValidators::EXPORT_TO_EXCEL, $this->domain);
        if ($oResponse["Response_Code"] != 200) {
            return ResponseBuilder::Response($oResponse);
        }

        /** @var ReportGroupPassengerResponse $response */
        $response = $this->queryBus->ask(new ReportGroupPassengerQuery(
            $Request->input('DateStart'),
            $Request->input('DateEnd')
        ));
        // dd($response->response());
        (new ExcelGroupPassengerReport())->exportToExcel($response->response());
    }
}
