<?php

namespace App\Http\Controllers\Owner\FactTypeReceipt;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeReceipt\Application\FactTypeReceiptResponses;
use App\Modules\FactTypeReceipt\Application\List\FactTypeReceiptListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeReceiptListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactTypeReceiptResponses $response */
        $response = $this->queryBus->ask(new FactTypeReceiptListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
