<?php
namespace App\Http\Controllers\Owner\FactTypeReceipt;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeReceipt\Application\FactTypeReceiptResponse;
use App\Modules\FactTypeReceipt\Application\Index\FactTypeReceiptIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeReceiptIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactTypeReceiptResponse $response */
        $response = $this->queryBus->ask(new FactTypeReceiptIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
