<?php
namespace App\Http\Controllers\Owner\FactTypeDocument;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeDocument\Application\FactTypeDocumentResponse;
use App\Modules\FactTypeDocument\Application\Index\FactTypeDocumentIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeDocumentIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactTypeDocumentResponse $response */
        $response = $this->queryBus->ask(new FactTypeDocumentIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
