<?php

namespace App\Http\Controllers\Owner\FactReceipt;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactReceipt\Application\Update\FactReceiptUpdaterQuery;
use App\Modules\FactReceipt\Application\Update\FactReceiptUpdaterResponse;
use App\Modules\FactReceipt\Infraestructure\FactReceiptValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactReceipt";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactReceiptValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactReceipt"));

        /** @var FactReceiptUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactReceiptUpdaterQuery(
            $request->input('Id_FactReceipt'),
            $request->input('FactReceipt_DateEmission'),
            $request->input('FactReceipt_NoDocument'),
            $request->input('FactReceipt_BusinessName'),
            $request->input('FactReceipt_Email'),
            $request->input('FactReceipt_Address'),
            '',
            $request->input('FactReceipt_Currency'),
            $request->input('Id_FactTypeReceipt'),
            $request->input('Id_FactTypeDocument'),
            $request->input('Id_FactPaymentMethod'),
            $request->input('Id_FactCurrency'),
        ));

        $this->history->updateBasic($request->input("Id_FactReceipt"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
