<?php

namespace App\Http\Controllers\Owner\FactPaymentMethod;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactPaymentMethod\Application\FactPaymentMethodResponse;
use App\Modules\FactPaymentMethod\Application\Index\IndexFactPaymentMethodQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactPaymentMethodIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "FactPaymentMethod";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var FactPaymentMethodResponse $response */
        $response = $this->queryBus->ask(new IndexFactPaymentMethodQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [$response],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Index',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
