<?php

namespace App\Http\Controllers\Owner\FactCurrency;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactCurrency\Application\Delete\DeleteFactCurrencyQuery;
use App\Modules\FactCurrency\Application\Delete\DeleteFactCurrencyResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class FactCurrencyDeleteController extends Controller
{
    private $domain = "FactCurrency";
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        $this->transaction->begin();
        /** @var DeleteFactCurrencyResponse $response */
        $response = $this->queryBus->ask(new DeleteFactCurrencyQuery($Id));

        $this->transaction->commit();
        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Moneda de Facturación eliminada con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
