<?php
namespace App\Http\Controllers\Owner\ExternalUserPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUserPassenger\Application\ExternalUserPassengerDeleter;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Infraestructure\MysqlExternalUserPassengerRepository;

class ExternalUserPassengerDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::EXTERNAL_USER_PASSENGER);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new ExternalUserPassengerDeleter(new MysqlExternalUserPassengerRepository()))
            ->__invoke(new IdExternalUserPassenger($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
