<?php
namespace App\Http\Controllers\Owner\ExternalReview;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\ExternalReview\Application\ExternalReviewIndexer;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReview\Infraestructure\MysqlExternalReviewRepository;

class ExternalReviewIndexController extends Controller
{
    public function __construct()
    {
    }

    public function __invoke($Id)
    {
        $response = (new ExternalReviewIndexer(new MysqlExternalReviewRepository()))
            ->__invoke(new IdExternalReview($Id));
        $response['Response_Data'] = array_map(
            function ($d) {
                $d->UserCountry_Img_Path = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB") . $d->UserCountry_Img;
                $d->External_Asset_Path = config("var.PATH_PUBLIC") . $d->External_Asset;
                return $d;
            },
            $response['Response_Data']
        );
        return ResponseBuilder::Response($response);
    }
}
