<?php

namespace App\Http\Controllers\Owner\Calendar;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Owner\c_Passenger;
use Illuminate\Http\Request;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Providers\Calendar\ExcelCalendarPaxReport\ExcelCalendarPaxColumnsWidth;
use App\Providers\Calendar\ExcelCalendarPaxReport\ExcelCalendarPaxReport;
use Illuminate\Support\Facades\DB;

class BookingCalendarPassengerExportExcellController extends Controller
{

    private $domain;
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Booking";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->domain, [
            'Id_CategoryTour'   => 'required|int',
            'Id_tour'           => 'required|int',
            'Date'              => 'required|string'
        ]);

        $oParam = array(
            $request->input("Id_CategoryTour"),
            $request->input("Id_tour"),
            $request->input("Date"),
            config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
        );

        $oData  = DB::select('call sp_tour_availability_pax_calendar_report(?,?,?,?)', $oParam);

        $oData = array_map(function ($pass) {
            $pass->Passenger_ImgDocument1_Path = c_Passenger::path1_large() . $pass->Passenger_ImgDocument1;
            $pass->Passenger_ImgDocument1_Thumb = c_Passenger::path1_thumb() . $pass->Passenger_ImgDocument1;
            $pass->Passenger_ImgDocument2_Path = c_Passenger::path2_large() . $pass->Passenger_ImgDocument2;
            $pass->Passenger_ImgDocument2_Thumb = c_Passenger::path2_thumb() . $pass->Passenger_ImgDocument2;
            return $pass;
        }, $oData);

        $oData = array_map(fn ($row) => $this->richRow($row), $oData);
        $oData = array_map(
            fn ($passenger, $index) => $this->markRowWithSameIdRoomBelow($passenger, $oData, $index),
            $oData,
            array_keys($oData)
        );
        (new ExcelCalendarPaxReport())
            ->exportToExcel(
                $oData
            );
        // dd($oData);
    }

    private function richRow($passenger)
    {
        $passenger->groupList = [];
        if ($passenger->Group_Count > 0) {
            $passenger->groupList = json_decode($passenger->Group_List);
        }

        $passenger->groupName = implode("\n", array_map(fn ($group) => $group->Group_Name, $passenger->groupList));
        $passenger->roomList = [];
        $room = json_decode($passenger->Room_List);
        if ($room[0]->Id_RoomPassenger !== null) {
            $passenger->room = $room[0];
        } else {
            $passenger->room = null;
        }
        return $passenger;
    }

    private function markRowWithSameIdRoomBelow($row, $rowList, $index)
    {
        if (!$row->room) {
            $row->rowsBelow = 0;
            $row->rowType = 'empty';
            return $row;
        }

        if (isset($row->rowType) && $row->rowType == 'child') {
            return $row;
        }

        $row->rowType = 'owner';
        $row->rowsBelow = 0;
        for ($i = $index + 1; $i < count($rowList); $i++) {
            if (!$rowList[$i]->room) {
                return $row;
            }
            if ($rowList[$i]->room && $rowList[$i]->room->Id_Room === $row->room->Id_Room && $rowList[$i]->Id_Tour === $row->Id_Tour) {
                $rowList[$i]->rowType = 'child';
                $row->rowsBelow++;
            } else {
                return $row;
            }
        }

        return $row;
    }
}
