<?php

namespace App\Http\Controllers\Owner\Calendar;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\BookingCalendar\Application\List\ListBookingCalendarQuery;
use App\Modules\BookingCalendar\Application\List\ListBookingCalendarResponse;
use App\Modules\BookingCalendar\Infrastructure\Validators\BookingCalendarValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingCalendarController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Booking Calendar";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, BookingCalendarValidators::LIST);

        /** @var ListBookingCalendarResponse $response */
        $response = $this->queryBus->ask(new ListBookingCalendarQuery(
            $request->get('Id_CategoryTour'),
            0,
            $request->get('Id_Tour'),
            0,
            $request->get('DateStart'),
            $request->get('DateEnd'),
            $request->header('Token', '')
        ));
        return ResponseBuilder::Response($response->response());
    }
}
