<?php

namespace App\Http\Controllers\Owner\BookingReport;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterQuery;
use App\Modules\AdminSession\Application\Index\AdminSessionGetterResponse;
use App\Modules\Booking\Application\SearchConfirm\SearchConfirmBookingQuery;
use App\Modules\Booking\Application\SearchConfirm\SearchConfirmBookingResponse;
use App\Modules\Booking\Infraestructure\BookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingReportConfirmController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingValidators::SEARCH_CONFIRM);

        /** @var AdminSessionGetterResponse */
        $admin = $this->queryBus->ask(new AdminSessionGetterQuery($request->header('Token')));

        /** @var SearchConfirmBookingResponse $response */
        $response = $this->queryBus->ask(new SearchConfirmBookingQuery(
            $request->input('Date_Start'),
            $request->input('Date_End'),
            $request->input('Order_By'),
        ));
        $responseData = $response->response();
        $responseData['Response_Data'] = array_map([$this, 'richData']($admin), $responseData['Response_Data']);

        return ResponseBuilder::Response($responseData);
    }

    private function richData($admin)
    {
        return function ($booking) use ($admin) {
            if ($booking->Admin_ImgProfile) {
                $booking->Admin_ImgProfile = config('var.PATH_PUBLIC') . $booking->Admin_ImgProfile;
            }
            if ($booking->Admin_ImgProfile_Thumb) {
                $booking->Admin_ImgProfile_Thumb = config('var.PATH_PUBLIC') . $booking->Admin_ImgProfile_Thumb;
            }
            $booking->BookingAssign = json_decode($booking->BookingAssign);
            foreach ($booking->BookingAssign as $bookingAssign) {
                if ($bookingAssign->Admin_ImgProfile_Thumb) {
                    $bookingAssign->Admin_ImgProfile_Thumb = config('var.PATH_PUBLIC') . $bookingAssign->Admin_ImgProfile_Thumb;
                }
            }
            $booking->User_Path = config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB");
            $booking->Id_Current = $admin->response()[0]->Response_Id_Admin;
            $booking->Id_CurrentRole = $admin->response()[0]->Response_Id_AdminRole;
            $booking->CurrentRole_Admin = $admin->response()[0]->Response_AdminRole_Admin;
            return $booking;
        };
    }
}
