<?php

namespace App\Http\Controllers\Owner\Booking;

use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use Illuminate\Support\Facades\DB;

class BookingUpdater
{
    public function __construct(
        private PassengerUpdater $passengerUpdater
    ) {
    }

    public function updatePassengers($idBooking)
    {
        $booking = $this->indexBooking($idBooking);
        $passengers = $this->listPassengers($idBooking);

        array_map(fn ($pass) => $this->passengerUpdater->updateLockHtlCampBookingPassenger(
            $pass->Id_Passenger,
            $booking
        ), $passengers);
    }

    private function indexBooking($idBooking)
    {
        return DB::select('CALL sp_booking_index(?)', [$idBooking])[0];
    }

    private function listPassengers($idBooking)
    {
        return DB::select('CALL sp_passenger_list(?,?,?,?,?,?,?)', ['all', $idBooking, 0, '', '', '', '']);
    }
}
