<?php
namespace App\Http\Controllers\Mail;

abstract class c_Mail_Column {
    
    /** @var c_Mail_Row */
    public $row;
    
    /** @var string */
    public $text;
    
    /** @var int */
    public $colspan = 1;
    
    /** @var int */
    public $rowspan = 1;

    /** @var string */
    public $align = 'left';

    /** @var string */
    public $fontWeight = 400;

    /** @var string */
    public $fontSize = '.9em';

    public $borderWidth = '1px';

    public $padding = '5px 10px';

    /** @var string */
    public $width = null;

    public function __construct($text) {
        $this->text = $text;
    }

    public abstract function getBackgroundColor ();

    public abstract function getTextColor ();
    
    public abstract function getBorderWidth ();

    public function setColspan ($colspan) {
        $this->colspan = $colspan;
        return $this;
    }

    public function setBold () {
        $this->fontWeight = 600;
        return $this;
    }

    public function setRowspan ($rowspan) {
        $this->rowspan = $rowspan;
        return $this;
    }

    public function setAlign ($alignment) {
        $this->align = $alignment;
        return $this;
    }

    public function setFontSize ($fontSize) {
        $this->fontSize = $fontSize;
        return $this;
    }

    public function setWidth($width) {
        $this->width = $width;
        return $this;
    }

    public function setPadding($padding) {
        $this->padding = $padding;
        return $this;
    }

    public function __toString() {
        return '<td ' .
        ' colspan="' . $this->colspan . '" ' .
        ' rowspan="' . $this->rowspan . '" ' .
        'style="border: ' . $this->getBorderWidth() . ' solid black; line-height: 1.5; ' .
        'padding:' . $this->padding .'; ' .
        ($this->width ? 'width: ' . $this->width . '; ' : '') .
        'text-align:' . $this->align . '; ' .
        'font-weight:' . $this->fontWeight . '; ' .
        'font-size:' . $this->fontSize . '; ' .
        'background-color:' . $this->getBackgroundColor() . '; ' .
        'color: ' . $this->getTextColor() . '">' . $this->text . '</td>';
    }

}