<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\Shared\Domain\ValueObject\DateValueObject;
use Illuminate\Support\Facades\DB;

class c_Cash_Movement extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Cash Movement";
    }

    public function Insert(Request $Request)
    {
        $oSuccess   = true;
        $oResponse  = array();
        $oValParams = array(
            'CashMovement_Amount'           => 'required|numeric',
            'CashMovement_Currency'         => 'required|string|max:4',
            'CashMovement_Name'             => 'required|string|max:100',
            'CashMovement_LastName'         => 'string|max:100',
            'CashMovement_Email'            => 'string|max:250',
            'CashMovement_Country'          => 'string|max:100',
            'CashMovement_City'             => 'string|max:100',
            'CashMovement_Address'          => 'string|max:250',
            'CashMovement_Phone'            => 'string|max:50',
            'CashMovement_ReceiptNumber'    => 'string|max:100',
            'CashMovement_CardLast'         => 'required|string|max:10',
            'CashMovement_CardNumber'       => 'required|string|max:20',
            'CashMovement_CardBrand'        => 'required|string|max:50',
            'CashMovement_CardType'         => 'required|string|max:50',
            'CashMovement_CardIssuer'       => 'required|string|max:50',
            'CashMovement_Remark'           => 'string',
            'Invoices'                      => 'required|string',
            'Id_TypePayment'                => 'int'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(
                DateValueObject::reducedNowToPeru(),
                $Request->input("CashMovement_Amount"),
                $Request->input("CashMovement_Currency"),
                $Request->input("CashMovement_Name"),
                $Request->input("CashMovement_LastName"),
                $Request->input("CashMovement_Email"),
                $Request->input("CashMovement_Country"),
                $Request->input("CashMovement_City"),
                $Request->input("CashMovement_Address"),
                $Request->input("CashMovement_Phone"),
                $Request->input("CashMovement_ReceiptNumber"),
                $Request->input("CashMovement_CardLast"),
                $Request->input("CashMovement_CardNumber"),
                $Request->input("CashMovement_CardBrand"),
                $Request->input("CashMovement_CardType"),
                $Request->input("CashMovement_CardIssuer"),
                $Request->input("CashMovement_Remark") == null ? '' : $Request->input("CashMovement_Remark"),
                $Request->input("Id_TypePayment") == null ? 1 : $Request->input("Id_TypePayment"),
            );
            $oData = DB::select('call sp_cash_movement_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {

                $oInvoice = json_decode($Request->input("Invoices"));

                for ($k = 0; $k < count($oInvoice); $k++) {

                    $oDataCashDetail = DB::select('call sp_cash_movement_detail_insert(?,?,?,?,?)', [
                        $oInvoice[$k]->Amount,
                        $oData[0]->Id_CashMovement,
                        $oInvoice[$k]->Id_Invoice,
                        1,
                        1
                    ]);

                    if ($oDataCashDetail[0]->Response_Success == 0) {
                        $oSuccess = false;
                        break;
                    }
                }

                if ($oSuccess == true) {
                    $oData = [[
                        "Response_Status"   => 200,
                        "Response_Code"     => 200,
                        "Response_Message"  => "Pasajeros guardados con éxito",
                        "Response_Reason"   => null
                    ]];

                    $oData = json_decode(json_encode($oData));
                }
                //BookingMailSender::sendBookingByMailInvoice($Request->input('Id_Invoice'), $this->oDomain);
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index($Id)
    {

        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oData  = DB::select('call sp_cash_movement_index(?)', [$Id]);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
