<?php

namespace App\Http\Controllers\Client\Package;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageResponse;
use App\Modules\WebContactMessage\Infraestructure\WebContactMessageValidators;

class PackageAvailabilityListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessage";
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageValidators::INSERT_CLIENT);

        /** @var CreateWebContactMessageResponse $response */
        // $response = $this->queryBus->ask(new CreateWebContactMessageQuery(
        //     $request->input('WebContactMessage_Message'),
        //     WebContactMessageStatus::defaultValue(),
        //     $createWebContactResponse->response()['Response_Data']['Id'],
        // ));

        // return ResponseBuilder::Response($response->response());
    }
}
