<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;
use Faker\Factory;

class UserCountryMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_UserCountry' => $id,
            'UserCountry_Name' => 'Afghanistan',
            'UserCountry_Code' => 'AFG',
            'UserCountry_PhoneCode' => '93',
            'UserCountry_Img' => '0001.jpg',
            'UserCountry_Frequent' => $faker->randomElement([1, 2]),
            'UserCountry_FrequentOrder' => 1,
            'UserCountry_Status' => 2
        ];
    }
    
    public static function build2($id = 1) {
        $faker = Factory::create();
        return [
            'Id_UserCountry' => $id,
            'UserCountry_Name' => 'Albania',
            'UserCountry_Code' => 'ALB',
            'UserCountry_PhoneCode' => '355',
            'UserCountry_Img' => '0002.jpg',
            'UserCountry_Frequent' => $faker->randomElement([1, 2]),
            'UserCountry_FrequentOrder' => 1,
            'UserCountry_Status' => 2
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    public static function push2($id = 1) {
        return self::push(self::build2($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_user_country_insert` (?,?,?,?,?,?,?)", [
            $object['UserCountry_Name'],
            $object['UserCountry_Code'],
            $object['UserCountry_PhoneCode'],
            $object['UserCountry_Img'],
            $object['UserCountry_Frequent'],
            $object['UserCountry_FrequentOrder'],
            $object['UserCountry_Status']
        ]);
        return $object;
    }

}