<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

trait DBTransactionWrapper {

    protected function setUp():void {
        parent::setUp();
        $this->runDBTransactionWrapper();
    }
    /**
     * Handle database transactions on the specified connections.
     *
     * @return void
     */
    public function runDBTransactionWrapper() {
        
        DB::beginTransaction();

        $this->beforeApplicationDestroyed(function () {
            DB::rollBack();
        });
    }

}
