<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TourTranslMother {

    public static function build1($idTour = null, $idLanguage = null, $id = 1) {
        $faker = Factory::create();
        $idTour = $idTour ?? TourMother::push1()['Id_Tour'];
        $idLanguage = $idLanguage ?? LanguageMother::push1()['Id_Language'];
        return [
            'Id_TourTransl' => $id,
            'TourTransl_Title' => Str::title($faker->text(rand(5, 250))),
            'Id_Tour' => $idTour,
            'Id_Language' => $idLanguage
        ];
    }

    public static function push1($idTour = null, $idLanguage = null, $id = 1) {
        return self::push(self::build1($idTour, $idLanguage, $id));
    }
    
    private static function push($object) {
        $response = DB::select("CALL `sp_tour_transl_insert` (?,?,?,?)", [
            $object['TourTransl_Title'],
            $object['Id_Tour'],
            $object['Id_Language'],
            1
        ]);
        $object['Id_TourTransl'] = DB::select('SELECT LAST_INSERT_ID() AS `Id`')[0]->Id;
        return $object;
    }

}