<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class QuestionTranslMother
{
    
    public static function build1($idQuestion, $idLanguage, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_QuestionTransl'     => $id,
            'QuestionTransl_Title'  => Str::title($faker->text(rand(5, 250))),
            'Id_Question'           => $idQuestion,
            'Id_Language'           => $idLanguage
        ];
    }

    public static function push1($idQuestion, $idLanguage, $id = 1)
    {
        return self::push(self::build1($idQuestion, $idLanguage, $id));
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_question_transl_insert` (?,?,?,?)",
            [
                $object['QuestionTransl_Title'],
                $object['Id_Question'],
                $object['Id_Language'],
                1
            ]
        );
        $object['Id_QuestionTransl'] = $response[0]->Response_Id;
        return $object;
    }

}