<?php

namespace App\DBRealTestSupport;

use App\Modules\AdminRole\Domain\AdminRole;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PaxInformationMother
{
    
    public static function build1($idBooking = null, $idAdmin = null, $id = 1)
    {
        $faker = Factory::create();
        $idBooking ?? BookingMother::pushRelationshipAndReferredFrom();
        return [
            'Id_PaxInformation'                 => $id,
            'PaxInformation_Date'               => date('Y-m-d H:i:s'),
            'PaxInformation_DateExpire'         => date('Y-m-d H:i:s', strtotime('+1 day')),
            'PaxInformation_DateModify'         => date('Y-m-d H:i:s'),
            'PaxInformation_Description'        => $faker->text(rand(5, 250)),
            'PaxInformation_TotalPassengers'    => 0,
            'PaxInformation_Remaining'          => $faker->randomElement([2, 3, 4, 5]),
            'PaxInformation_Status'             => $faker->randomElement([1]),
            'PaxInformation_Token'              => '',
            'Id_Booking'                        => $idBooking ?? self::genBooking(),
            'Id_Admin'                          => $idAdmin ?? self::genAdmin(),
            'PaxInformation_Passenger'          => '[]'
        ];
    }

    private static function genAdmin()
    {
        return AdminMother::push1(
            TypeDocumentMother::push1()['Id_TypeDocument'],
            AdminRoleMother::push1()['Id_AdminRole'],
            CountryMother::push1()['Id_Country'],
            StateMother::push1(CountryMother::push1()['Id_Country'])['Id_State'],
            CityMother::push1(StateMother::push1(CountryMother::push1()['Id_Country'])['Id_State'])['Id_City']
        )['Id_Admin'];
    }

    private static function genBooking()
    {
        return BookingMother::push1(
            AdminMother::push1(
                TypeDocumentMother::push1()['Id_TypeDocument'],
                AdminRoleMother::push1()['Id_AdminRole'],
                CountryMother::push1()['Id_Country'],
                StateMother::push1(CountryMother::push1()['Id_Country'])['Id_State'],
                CityMother::push1(StateMother::push1(CountryMother::push1()['Id_Country'])['Id_State'])['Id_City']
            )['Id_Admin'],
            LanguageMother::pushBasic()['Id_Language'],
            LanguageMother::pushBasic()['Id_Language'],
            UserMother::push1(
                TypeDocumentMother::push1()['Id_TypeDocument'],
                UserCountryMother::push1()['Id_UserCountry'],
            )['Id_User'],
            AdminSessionMother::createSession()['AdminSession_Token'],
        )['Id_Booking'];
    }

    public static function push1($idBooking = null, $idAdmin = null, $id = 1)
    {
        return self::push(self::build1($idBooking, $idAdmin, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_pax_information_insert` (?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['PaxInformation_Description'],
            $object['PaxInformation_Remaining'],
            $object['PaxInformation_DateExpire'],
            $object['PaxInformation_Status'],
            $object['Id_Booking'],
            $object['Id_Admin'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_PaxInformation'] = $response[0]->{'@id'};
        }
        return $object;
    }
}
