<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class PackageTourUpgradeMother {
    
    public static function build1($idPackageTour, $idUpgrade = null, $id = 1) {
        $faker = \Faker\Factory::create();
        $idUpgrade = $idUpgrade ?? UpgradeMother::push1()['Id_Upgrade'];
        return [
            'Id_PackageTourUpgrade' => $id,
            // 'PackageTourUpgrade_Passenger' => $faker->randomElement([1, 2]),
            'PackageTourUpgrade_Passenger' => 2,
            'Id_PackageTour' => $idPackageTour,
            'Id_Upgrade' => $idUpgrade,
        ];
    }

    public static function push1($idPackageTour, $idUpgrade = null, $id = 1) {
        return self::push(self::build1($idPackageTour, $idUpgrade, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_package_tour_upgrade_insert` (?,?,?)", [
            $object['PackageTourUpgrade_Passenger'],
            $object['Id_PackageTour'],
            $object['Id_Upgrade'],
        ]);
        $object['Id_PackageTourUpgrade'] = $response[0]->Response_Id;
        return $object;
    }

}