<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class PackageTourEquipmentMother {
    
    public static function build1($idPackageTour, $idEquipment = null, $id = 1) {
        $faker = \Faker\Factory::create();
        $idEquipment = $idEquipment ?? EquipmentMother::push1()['Id_Equipment'];
        return [
            'Id_PackageTourEquipment' => $id,
            // 'PackageTourEquipment_Passenger' => $faker->randomElement([1, 2]),
            'PackageTourEquipment_Passenger' => 2,
            'Id_PackageTour' => $idPackageTour,
            'Id_Equipment' => $idEquipment,
        ];
    }

    public static function push1($idPackageTour, $idEquipment = null, $id = 1) {
        return self::push(self::build1($idPackageTour, $idEquipment, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_package_tour_equipment_insert` (?,?,?)", [
            $object['PackageTourEquipment_Passenger'],
            $object['Id_PackageTour'],
            $object['Id_Equipment'],
        ]);
        $object['Id_PackageTourEquipment'] = $response[0]->Response_Id;
        return $object;
    }

}