<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class InvoiceMother
{

    public static function build1(
        $idBooking,
        $idPassenger,
        $idCashMovement = 0,
        $id = 1
    ) {
        $faker = Factory::create();
        return [
            'Id_Invoice'            => $id,
            'Invoice_Date'          => date('Y-m-d H:i:s'),
            'Invoice_Code'          => '',
            'Invoice_Total'         => '0',
            'Invoice_TotalPay'      => '0',
            'Invoice_TotalPending'  => '0',
            'Invoice_Status'        => 2,
            'Id_CashMovement'       => $idCashMovement,
            'Id_Booking'            => $idBooking,
            'Id_Passenger'          => $idPassenger,
        ];
    }

    public static function push1(
        $idBooking,
        $idPassenger,
        $idCashMovement = 0,
        $id = 1
    ) {
        return self::push(self::build1(
            $idBooking,
            $idPassenger,
            $idCashMovement,
            $id
        ));
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_invoice_insert`(?,?,?)",
            [
                $object['Id_Booking'],
                $object['Id_Passenger'],
                1
            ]
        );
        $object['Id_Invoice'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            BookingMother::clear(),
            [
                TC::passenger
            ]
        );
    }
}
