<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class HtlBedMother
{

    public static function build1($idHtlCamp = null, $id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_HtlBed' => $id,
            'HtlBed_Name' => $faker->text(rand(5, 250)),
            'HtlBed_Description' => $faker->text(rand(5, 500)),
            'HtlBed_Availability' => rand(0, 5000),
            'HtlBed_Status' => $faker->randomElement([1, 2]),
            'Id_HtlCamp' => $idHtlCamp ?? HtlCampMother::push1()['Id_HtlCamp']
        ];
    }

    public static function push1($idHtlCamp = null, $id = 0)
    {
        return self::push(self::build1($idHtlCamp, $id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_htl_bed`(
                `Id_HtlBed`, `HtlBed_Name`, `HtlBed_Description`, `HtlBed_Availability`, `HtlBed_Status`, `Id_HtlCamp`
            )
            VALUES (?,?,?,?,?,?)", [
            $object['Id_HtlBed'] == 0 ? null : $object['Id_HtlBed'],
            $object['HtlBed_Name'],
            $object['HtlBed_Description'],
            $object['HtlBed_Availability'],
            $object['HtlBed_Status'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_HtlBed'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::HTL_BED, ...HtlCampMother::tablesToClear()];
    }
}
