<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExternalReviewMother
{
    
    public static function build1(
        $idAdmin,
        $idExternalUser = 0,
        $idExternalUserPassenger = 0,
        $idGroupPassenger = 0,
        $idBookingRelationship = 0,
        $idExternalReview_Parent = 0,
        $idExternal = null,
        $idLanguage = null,
        $id = 1
    ) {
        $idExternal = $idExternal ?? ExternalMother::push1()['Id_External'];
        $idLanguage = $idLanguage ?? LanguageMother::pushBasic()['Id_Language'];
        $faker = Factory::create();
        return [
            'Id_ExternalReview' => $id,
            'ExternalReview_Date' => date('Y-m-d H:i:s'),
            'ExternalReview_DateReview' => date('Y-m-d'),
            'ExternalReview_Route' => $faker->text(rand(5, 250)),
            'ExternalReview_Title' => $faker->text(rand(5, 250)),
            'ExternalReview_Value' => $faker->text(rand(5, 5000)),
            'ExternalReview_Score' => $faker->randomElement([1, 2, 3, 4, 5]),
            'ExternalReview_Type' => $faker->randomElement([1, 2]),
            'ExternalReview_Status' => $faker->randomElement([1, 2]),
            'Id_ExternalUser' => $idExternalUser,
            'Id_ExternalUserPassenger' => $idExternalUserPassenger,
            'Id_GroupPassenger' => $idGroupPassenger,
            'Id_BookingRelationship' => $idBookingRelationship,
            'Id_Language' => $idLanguage,
            'Id_External' => $idExternal,
            'Id_Admin' => $idAdmin,
            'Id_ExternalReview_Parent' => $idExternalReview_Parent,
        ];
    }

    public static function push1(
        $idAdmin,
        $idExternalUser = 0,
        $idExternalUserPassenger = 0,
        $idGroupPassenger = 0,
        $idBookingRelationship = 0,
        $idExternalReview_Parent = 0,
        $idExternal = null,
        $idLanguage = null,
        $id = 1
    ) {
        return self::push(
            self::build1(
                $idAdmin,
                $idExternalUser,
                $idExternalUserPassenger,
                $idGroupPassenger,
                $idBookingRelationship,
                $idExternalReview_Parent,
                $idExternal,
                $idLanguage,
                $id
            )
        );
    }

    private static function push($object)
    {
        $response = DB::select(
            "CALL `sp_external_review_insert`(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
                $object['ExternalReview_DateReview'],
                $object['ExternalReview_Route'],
                $object['ExternalReview_Title'],
                $object['ExternalReview_Value'],
                $object['ExternalReview_Score'],
                $object['ExternalReview_Type'],
                $object['ExternalReview_Status'],
                $object['Id_ExternalUser'],
                $object['Id_ExternalUserPassenger'],
                $object['Id_GroupPassenger'],
                $object['Id_BookingRelationship'],
                $object['Id_Language'],
                $object['Id_External'],
                $object['Id_Admin'],
                $object['Id_ExternalReview_Parent'],
            ]
        );
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_ExternalReview'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::EXTERNAL_REVIEW,
            ...ExternalUserPassengerMother::tablesToClear()
        ];
    }
}
