<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class CredentialMother
{

    public const Tax                        = ['id' => 3, 'name' => 'Tax', 'value' => '18'];
    public const Web_URL                    = ['id' => 4, 'name' => 'Web_URL', 'value' => 'http://localhost:4200/'];
    public const Config_AccessTokenMinutes  = ['id' => 24, 'name' => 'Config_AccessTokenMinutes', 'value' => '100'];
    public const Config_Fee                 = ['id' => 25, 'name' => 'Config_Fee', 'value' => '0.05'];
    public const Mail                       = ['id' => 2, 'name' => 'Mail', 'value' => 'jesuscuri13@gmail.com'];
    public const Mail_Payments              = ['id' => 16, 'name' => 'Mail_Payments', 'value' => 'jesuscuri13@gmail.com'];
    public const Resources_URL              = ['id' => 5, 'name' => 'Resources_URL', 'value' => 'http://media.resources.salkantay-trekking.com/'];
    public const Text_BriefingPlace         = ['id' => 17, 'name' => 'Text_BriefingPlace', 'value' => ''];
    public const Email_Host                 = ['id' => 9, 'name' => 'Email_Host', 'value' => 'smtp.gmail.com'];

    public static $insertedCredentials;

    public static function insert(...$credentialList)
    {
        foreach ($credentialList as $credential) {
            self::addCredential($credential);
        }
    }

    public static function insertBasicCredentials()
    {
        CredentialMother::insert(CredentialMother::Text_BriefingPlace);
        CredentialMother::insert(CredentialMother::Web_URL);
    }

    public static function addCredential($credential)
    {
        if (isset(self::$insertedCredentials[$credential['name']])) {
            return;
        }
        DB::select(
            'INSERT INTO `t_credential` (`Id_Credential`, `Credential_Key`, `Credential_Value`) VALUE (?,?,?)',
            [$credential['id'], $credential['name'], $credential['value']]
        );

        self::$insertedCredentials[$credential['name']] = $credential;
    }
    public static function clear()
    {
        self::$insertedCredentials = [];
    }
}
