<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class BookingReferredFromMother {
    
    public static function build1($lock, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_BookingReferredFrom' => $id,
            'BookingReferredFrom_Name' => Str::title($faker->text(rand(5, 250))),
            'BookingReferredFrom_Abrv' => Str::upper(Util::generateString(4)),
            'BookingReferredFrom_Lock' => $lock,
            'BookingReferredFrom_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($lock, $id = 1) {
        return self::push(self::build1($lock, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_booking_referred_from_insert` (?,?,?,?)", [
            $object['BookingReferredFrom_Name'],
            $object['BookingReferredFrom_Abrv'],
            $object['BookingReferredFrom_Lock'],
            $object['BookingReferredFrom_Status']
        ]);
        $object['Id_BookingReferredFrom'] = $response[0]->Response_Id;
        return $object;
    }

}