<?php

namespace App\DBRealTestSupport\Booking\Data;

use App\DBRealTestSupport\Booking\BookingBasicData;
use App\DBRealTestSupport\Booking\PackageOptions;
use App\DBRealTestSupport\Booking\PackageTourOptions;
use App\DBRealTestSupport\BookingTourMother;
use App\DBRealTestSupport\PackageFeeMother;
use App\DBRealTestSupport\PackageMother;
use App\DBRealTestSupport\PackageRateMother;
use App\DBRealTestSupport\PackageTourMother;
use App\DBRealTestSupport\PackageTranslMother;
use App\DBRealTestSupport\PassengerMother;
use App\DBRealTestSupport\TourMother;
use App\DBRealTestSupport\TourTranslMother;
use DateTime;
use Illuminate\Support\Facades\DB;

class DataBooking
{
    public function __construct(
        public int $Id_Booking,
        public DateTime $Booking_Date,
        public DateTime $Booking_DateConfirm,
        public DateTime $Booking_DateStart,
        public DateTime $Booking_DateBriefing,
        public string $Booking_PlaceBriefing,
        public string $Booking_Code,
        public string $Booking_HistoryChanges,
        public string $Booking_Hotel,
        public string $Booking_Observation,
        public string $Booking_InternalRemark,
        public int $Booking_Receipt,
        public int $Booking_Type,
        public int $Booking_LastMinute,
        public int $Booking_Assigned,
        public int $Booking_Status,
        public int $Booking_ManuallyConfirmed,
        public int $Booking_InPerson,
        public int $Booking_PassengerAmount,
        public int $Booking_CheckedInPassengers,
        public int $Booking_LastPassenger,
        public string $Booking_Token,
        public int $Id_Booking_Replace,
        public int $Id_Admin,
        public int $Id_GuideLanguage,
        public int $Id_Language,
        public int $Id_User,
        public int $Id_User_Additional,
        public int $Id_BookingRelationship,
        public int $Id_BookingReferredFrom,
    ) {}

    public function save(string $token)
    {
        $response = DB::select("CALL `sp_booking_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $this->Booking_DateStart->format('Y-m-d'),
            $this->Booking_Receipt,
            $this->Booking_Type,
            $this->Booking_Observation,
            $this->Booking_InternalRemark,
            $this->Id_Language,
            $this->Id_GuideLanguage,
            $this->Id_User,
            $this->Id_User_Additional,
            $this->Booking_InPerson,
            $this->Id_BookingRelationship,
            $this->Id_BookingReferredFrom,
            $token
        ]);
        $this->Id_Booking = $response[0]->Response_Id;
        return $this;
    }

    public function passenger(BookingBasicData $basicData)
    {
        $passenger = PassengerMother::push1(
            $this->Id_Booking,
            $basicData->Id_TypeDocument,
            $basicData->Id_UserCountry,
            $basicData->Id_TypeRate
        );
        $params = [$this->Id_Booking, $passenger['Id_Passenger'], 1];
        DB::select('call sp_invoice_insert(?,?,?)', $params);
        return $passenger;
    }

    public function package(PackageOptions $options, BookingBasicData $basicData)
    {
        $idPackage = $options->idPackage ?? $this->generatePackage($basicData);
        $tours = $options->tourOptions ? $this->generateTours($idPackage, $options->tourOptions, $basicData) : [];

        $bookingTour = $this->generateBookingTours($this->Id_Booking, $idPackage, $tours);
        return [
            'Id_Package' => $idPackage,
            'Tours' => $tours,
            'BookingTour' => $bookingTour
        ];
    }

    private function generateBookingTours($idBooking, $idPackage, $tours)
    {
        return array_map(fn($tour) => $this->generateBookingTour($idBooking, $idPackage, $tour['Id_Tour']), $tours);
    }

    private function generateBookingTour($idBooking, $idPackage, $idTour)
    {
        return BookingTourMother::pushShared1($idBooking, $idPackage, $idTour);
    }

    private function generatePackage(BookingBasicData $basicData)
    {
        $idPackage = PackageMother::push1()['Id_Package'];
        PackageTranslMother::push1($idPackage, $basicData->Id_Language);
        $packageRate = PackageRateMother::pushPublic($idPackage, $basicData->Id_TypeRate);
        PackageFeeMother::pushFull1($packageRate['PackageRate_Price'], $idPackage);
        return $idPackage;
    }

    /**
     * @param PackageTourOptions[] $tours
     */
    private function generateTours($idPackage, array $tours, BookingBasicData $basicData)
    {
        return array_map(
            function (PackageTourOptions $tour) use ($idPackage, $basicData) {
                $idTour = $tour->idTour ?? TourMother::push1()['Id_Tour'];
                TourTranslMother::push1($idTour, $basicData->Id_Language);
                $idPackageTour = PackageTourMother::push1($idPackage, $idTour)['Id_PackageTour'];
                return [
                    'Id_Tour' => $idTour,
                    'Id_PackageTour' => $idPackageTour
                ];
            },
            $tours
        );
    }
}
