<?php

namespace App\DBRealTestSupport\Booking;

use App\DBRealTestSupport\BookingMother;
use App\DBRealTestSupport\CategoryTourMother;
use App\DBRealTestSupport\LanguageMother;
use App\DBRealTestSupport\TypeRateMother;
use App\DBRealTestSupport\TypeTourMother;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\Booking\Domain\BookingType;
use App\Modules\Booking\Domain\InsertBookingModel;
use App\Modules\BookingReferredFrom\Domain\IdBookingReferredFrom;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;

class BookingBuilder
{

    private BookingType $bookingType;
    private BookingStatus $bookingStatus;
    private ?IdAdmin $idAdmin;
    private ?int $idGuideLanguage;
    private ?int $idLanguage;
    private ?int $idUser;
    private ?IdBookingRelationship $idBookingRelationship;
    private ?IdBookingReferredFrom $idBookingReferredFrom;

    public $bookingData;
    public $categoryTour;
    public $typeTour;
    public $typeRate;

    public $proccessBooking = null;

    public function __construct()
    {
    }

    public function init()
    {
        LanguageMother::pushBasicDefault();
        BookingMother::pushRelationshipAndReferredFrom();
    }

    public function prepare()
    {
        $this->bookingData = BookingMother::prepare();
        $this->categoryTour = CategoryTourMother::push1();
        $this->typeTour = TypeTourMother::push1();
        $this->typeRate = TypeRateMother::push1();
    }

    public function build($admin)
    {
        $this->proccessBooking = BookingMother::build1(
            $admin['Id_Admin'],
            $this->bookingData['guideLanguage']['Id_Language'],
            $this->bookingData['language']['Id_Language'],
            $this->bookingData['user']['Id_User']
        );
    }

    public function push()
    {
    }
}
