<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Http\Controllers\Owner\RedisController;
use Illuminate\Support\Facades\Route;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Event\EventBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Infraestructure\Command\InMemoryCommandBus;
use App\Modules\Shared\Infraestructure\Event\InMemoryEventBus;
use App\Modules\Shared\Infraestructure\LaravelTransaction;
use App\Modules\Shared\Infraestructure\Query\InMemoryQueryBus;

// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// //                                                                                                                           //
// //                                                    RUTAS API OWNER                                                        //
// //                                                                                                                           //
// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
$app = app();
$app->bind(CommandBus::class, fn ($app) => (new InMemoryCommandBus()));
$app->bind(QueryBus::class, fn ($app) => (new InMemoryQueryBus()));
$app->bind(EventBus::class, fn ($app) => (new InMemoryEventBus([])));
$app->bind(Transaction::class, fn ($app) => (new LaravelTransaction()));

Route::group(
    [
        "namespace" => "App\Http\Controllers\Owner",
        "prefix"    => "owner"
    ],
    function () use ($router, $app) {

        Route::get("/redis", ["uses" => RedisController::class . "@__invoke"]);

        //
        // ADMINISTRADOR
        //
        $router->post("/login", ["uses" => "c_Admin_Session@Insert"]);
        $router->get("/session", ["uses" => "c_Admin_Session@Index"]);

        include __DIR__ . '/owner/adminSession.php';
        include __DIR__ . '/owner/admin.php';

        //
        // CREDENTIAL
        //
        $router->put('/credential', ['middleware' => 'Auth_Owner', 'uses' => 'c_Credential@Update']);
        $router->get('/credential/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Credential@Index']);
        $router->get('/credential', ['middleware' => 'Auth_Owner', 'uses' => 'c_Credential@List']);

        //region TABLAS DE SISTEMA

        //
        // LANGUAGE
        //
        $router->post('/language', ['middleware' => 'Auth_Owner', 'uses' => 'Language@Insert']);
        $router->put('/language', ['middleware' => 'Auth_Owner', 'uses' => 'Language@Update']);
        $router->delete('/language/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'Language@Delete']);
        $router->get('/language/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'Language@Selector']);



        //
        // COUNTRY
        //
        $router->post('/country', ['middleware' => 'Auth_Owner', 'uses' => 'c_Country@Insert']);
        $router->put('/country', ['middleware' => 'Auth_Owner', 'uses' => 'c_Country@Update']);
        $router->delete('/country/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Country@Delete']);
        $router->get('/country/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Country@Selector']);
        //
        // STATE
        //
        $router->post('/state', ['middleware' => 'Auth_Owner', 'uses' => 'c_State@Insert']);
        $router->put('/state', ['middleware' => 'Auth_Owner', 'uses' => 'c_State@Update']);
        $router->delete('/state/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_State@Delete']);
        $router->get('/state/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_State@Index']);
        $router->get('/country/{Id_Country}/state/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_State@List']);
        //
        // CITY
        //
        $router->post('/city', ['middleware' => 'Auth_Owner', 'uses' => 'c_City@Insert']);
        $router->put('/city', ['middleware' => 'Auth_Owner', 'uses' => 'c_City@Update']);
        $router->delete('/city/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_City@Delete']);
        $router->get('/city/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_City@Index']);
        $router->get('/state/{Id_State}/city/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_City@List']);

        include __DIR__ . '/owner/typeReceipt.php';
        include __DIR__ . '/owner/typeProvider.php';

        //
        // TYPE ITEM
        //
        $router->post('/typeItem', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Item@Insert']);
        $router->put('/typeItem', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Item@Update']);
        $router->delete('/typeItem/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Item@Delete']);
        $router->get('/typeItem/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Item@Selector']);


        //endregion

        //region CATEGORY TOUR

        //
        // CATEGORY TOUR
        //
        $router->post('/categoryTour', ['middleware' => 'Auth_Owner', 'uses' => 'c_Category_Tour@Insert']);
        $router->put('/categoryTour', ['middleware' => 'Auth_Owner', 'uses' => 'c_Category_Tour@Update']);
        $router->delete('/categoryTour/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Category_Tour@Delete']);
        $router->get('/categoryTour/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Category_Tour@Selector']);

        //endregion

        //region TABLAS DE SISTEMA CON TRADUCCION

        //
        //  TYPE DOCUMENT
        //
        $router->post('/typeDocument', ['middleware' => 'Auth_Owner', 'uses' => 'TypeDocument@insert']);
        $router->put('/typeDocument', ['middleware' => 'Auth_Owner', 'uses' => 'TypeDocument@update']);
        $router->delete('/typeDocument/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'TypeDocument@delete']);
        $router->get('/typeDocument/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'TypeDocument@selector']);
        //
        // TYPE DOCUMENT TRANSL
        //
        $router->post('/typeDocumentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Document_Transl@Insert']);
        $router->put('/typeDocumentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Document_Transl@Update']);
        $router->delete('/typeDocumentTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Document_Transl@Delete']);
        $router->get('/typeDocumentTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Document_Transl@Index']);
        $router->get('/typeDocument/{Id_TypeDocument}/typeDocumentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Document_Transl@List']);



        //
        // TYPE PAYMENT
        //
        $router->post('/typePayment', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment@insert']);
        $router->put('/typePayment', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment@Update']);
        $router->delete('/typePayment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment@Delete']);
        $router->get('/typePayment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment@Selector']);
        //
        // TYPE DOCUMENT TRANSL
        //
        $router->post('/typePaymentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment_Transl@Insert']);
        $router->put('/typePaymentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment_Transl@Update']);
        $router->delete('/typePaymentTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment_Transl@Delete']);
        $router->get('/typePaymentTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment_Transl@Index']);
        $router->get('/typePayment/{Id_TypePayment}/typePaymentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Payment_Transl@List']);



        //
        // TYPE TOUR
        //
        $router->post('/typeTour',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour@Insert']);
        $router->put('/typeTour',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour@Update']);
        $router->delete('/typeTour/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour@Delete']);
        $router->get('/typeTour/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour@Selector']);
        //
        // TYPE TOUR TRANSL
        //
        $router->post('/typeTourTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour_Transl@Insert']);
        $router->put('/typeTourTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour_Transl@Update']);
        $router->delete('/typeTourTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour_Transl@Delete']);
        $router->get('/typeTourTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour_Transl@Index']);
        $router->get('/typeTour/{Id_TypeTour}/typeTourTransl',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Tour_Transl@List']);


        //
        // TYPE UPGRADE
        //
        $router->post('/typeUpgrade',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade@Insert']);
        $router->put('/typeUpgrade',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade@Update']);
        $router->delete('/typeUpgrade/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade@Delete']);
        $router->get('/typeUpgrade/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade@Selector']);
        //
        // TYPE UPGRADE TRANSL
        //
        $router->post('/typeUpgradeTransl',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade_Transl@Insert']);
        $router->put('/typeUpgradeTransl',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade_Transl@Update']);
        $router->delete('/typeUpgradeTransl/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade_Transl@Delete']);
        $router->get('/typeUpgradeTransl/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade_Transl@Index']);
        $router->get('/typeUpgrade/{Id_TypeUpgrade}/typeUpgradeTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Upgrade_Transl@List']);


        //
        // TYPE EXTRA
        //
        $router->post('/typeExtra',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra@Insert']);
        $router->put('/typeExtra',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra@Update']);
        $router->delete('/typeExtra/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra@Delete']);
        $router->get('/typeExtra/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra@Selector']);
        //
        // TYPE EXTRA TRANSL
        //
        $router->post('/typeExtraTransl',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra_Transl@Insert']);
        $router->put('/typeExtraTransl',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra_Transl@Update']);
        $router->delete('/typeExtraTransl/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra_Transl@Delete']);
        $router->get('/typeExtraTransl/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra_Transl@Index']);
        $router->get('/typeExtra/{Id_TypeExtra}/typeExtraTransl',   ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Extra_Transl@List']);


        //
        // TYPE EQUIPMENT
        //
        $router->post('/typeEquipment',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment@Insert']);
        $router->put('/typeEquipment',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment@Update']);
        $router->delete('/typeEquipment/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment@Delete']);
        $router->get('/typeEquipment/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment@Selector']);
        //
        // TYPE EQUIPMENT TRANSL
        //
        $router->post('/typeEquipmentTransl',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment_Transl@Insert']);
        $router->put('/typeEquipmentTransl',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment_Transl@Update']);
        $router->delete('/typeEquipmentTransl/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment_Transl@Delete']);
        $router->get('/typeEquipmentTransl/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment_Transl@Index']);
        $router->get('/typeEquipment/{Id_TypeEquipment}/typeEquipmentTransl',   ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Equipment_Transl@List']);


        //
        // TYPE RATE
        //
        $router->post('/typeRate',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate@Insert']);
        $router->put('/typeRate',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate@Update']);
        $router->delete('/typeRate/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate@Delete']);
        $router->get('/typeRate/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate@Selector']);
        //
        // TYPE EQUIPMENT TRANSL
        //
        $router->post('/typeRateTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate_Transl@Insert']);
        $router->put('/typeRateTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate_Transl@Update']);
        $router->delete('/typeRateTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate_Transl@Delete']);
        $router->get('/typeRateTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate_Transl@Index']);
        $router->get('/typeRate/{Id_TypeRate}/typeRateTransl',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Rate_Transl@List']);


        //
        // TYPE ROOM
        //
        $router->post('/typeRoom',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room@Insert']);
        $router->put('/typeRoom',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room@Update']);
        $router->delete('/typeRoom/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room@Delete']);
        $router->get('/typeRoom/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room@Selector']);
        //
        // TYPE EQUIPMENT TRANSL
        //
        $router->post('/typeRoomTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room_Transl@Insert']);
        $router->put('/typeRoomTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room_Transl@Update']);
        $router->delete('/typeRoomTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room_Transl@Delete']);
        $router->get('/typeRoomTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room_Transl@Index']);
        $router->get('/typeRoom/{Id_TypeRoom}/typeRoomTransl',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Type_Room_Transl@List']);


        //endregion

        //region TABLAS DE QUESTION

        //
        //  QUESTION
        //
        $router->post('/question',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Question@Insert']);
        $router->put('/question',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Question@Update']);
        $router->delete('/question/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Question@Delete']);
        $router->get('/question/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Question@Selector']);
        //
        // TYPE DOCUMENT TRANSL
        //
        $router->post('/questionTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Question_Transl@Insert']);
        $router->put('/questionTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Question_Transl@Update']);
        $router->delete('/questionTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Question_Transl@Delete']);
        $router->get('/questionTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Question_Transl@Index']);
        $router->get('/question/{Id_Question}/questionTransl',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Question_Transl@List']);

        //endregion

        //region TABLAS DE ADMINISTRADOR

        //
        // ADMIN ROLE
        //
        $router->post('/adminRole',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role@Insert']);
        $router->put('/adminRole',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role@Update']);
        $router->delete('/adminRole/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role@Delete']);
        $router->get('/adminRole/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role@Selector']);
        $router->post('/adminRole/{Id_AdminRole}/copy',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role@Copy']);

        //
        // ADMIN ROLE AUTH
        //
        $router->post('/adminRoleAuth',                          ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@Insert']);
        $router->post('/adminRoleAuth/all',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@InsertAll']);
        $router->put('/adminRoleAuth',                          ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@Update']);
        $router->delete('/adminRoleAuth/{Id}',                     ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@Delete']);
        $router->get('/adminRoleAuth/{Id}',                     ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@Index']);
        $router->get('/adminRole/{Id_AdminRole}/adminRoleAuth', ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@List']);
        $router->get('/adminRoleAuthList',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Admin_Role_Auth@MenuList']);

        //endregion

        //region TABLAS DE PROVEEDORES

        //
        // PROVEEDOR
        //
        include __DIR__ . '/owner/provider.php';


        //endregion

        //region TABLAS DE ALMACEN

        //
        // ITEM
        //
        $router->post('/item',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Item@Insert']);
        $router->put('/item',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Item@Update']);
        $router->delete('/item/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Item@Delete']);
        $router->get('/item/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Item@Selector']);


        //
        // WAREHOUSE
        //
        $router->post('/warehouse',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse@Insert']);
        $router->put('/warehouse',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse@Update']);
        $router->delete('/warehouse/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse@Delete']);
        $router->get('/warehouse/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse@Selector']);


        //
        // ZONE
        //
        $router->post('/zone',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Zone@Insert']);
        $router->put('/zone',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Zone@Update']);
        $router->delete('/zone/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Zone@Delete']);
        $router->get('/zone/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Zone@Index']);
        $router->get('/warehouse/{Id_Warehouse}/zone/{Id}',    ['middleware' => 'Auth_Owner', 'uses' => 'c_Zone@List']);


        //
        // WAREHOUSE BALANCE
        //
        $router->post('/warehouseBalance',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse_Balance@Insert']);
        $router->put('/warehouseBalance',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse_Balance@Update']);
        $router->delete('/warehouseBalance/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse_Balance@Delete']);
        $router->get('/warehouseBalance/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse_Balance@Index']);
        $router->get('/warehouse/{Id_Warehouse}/warehouseBalance/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Warehouse_Balance@List']);


        //
        // REGISTRY CONFIGURATION
        //
        $router->post('/registryConfiguration',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Configuration@Insert']);
        $router->put('/registryConfiguration',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Configuration@Update']);
        $router->delete('/registryConfiguration/{Id}',     ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Configuration@Delete']);
        $router->get('/registryConfiguration/{Id}',     ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Configuration@Selector']);


        //
        // REGISTRY
        //
        $router->post('/registry',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Insert']);
        $router->put('/registry',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Update']);
        $router->put('/registry/status',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Status']);
        $router->delete('/registry/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Delete']);
        $router->get('/registry/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Index']);
        $router->get('/registry',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@Search']);
        $router->get('/registry/{Id_Registry}/report/excel', ['uses' => 'c_Registry@Report_Excel']);
        $router->get('/registryGetReport/{Id_Registry}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry@GetReport']);


        //
        // REGISTRY DETAIL
        //
        $router->post('/registryDetail/all',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@Insert_All']);
        $router->post('/registryDetail',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@Insert']);
        $router->put('/registryDetail',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@Update']);
        $router->delete('/registryDetail/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@Delete']);
        $router->get('/registryDetail/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@Index']);
        $router->get('/registry/{Id_Registry}/registryDetail', ['middleware' => 'Auth_Owner', 'uses' => 'c_Registry_Detail@List']);


        //endregion

        //region TABLAS DE UPGRADES

        //
        // UPGRADE
        //
        $router->post('/upgrade',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade@Insert']);
        $router->put('/upgrade',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade@Update']);
        $router->delete('/upgrade/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade@Delete']);
        $router->get('/upgrade/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade@Selector']);
        //
        // UPGRADE TRANSL
        //
        $router->post('/upgradeTransl',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade_Transl@Insert']);
        $router->put('/upgradeTransl',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade_Transl@Update']);
        $router->delete('/upgradeTransl/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade_Transl@Delete']);
        $router->get('/upgradeTransl/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade_Transl@Index']);
        $router->get('/upgrade/{Id_Upgrade}/upgradeTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Upgrade_Transl@List']);


        //endregion

        //region TABLAS DE EXTRAS

        //
        // EXTRA
        //
        $router->post('/extra',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra@Insert']);
        $router->put('/extra',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra@Update']);
        $router->delete('/extra/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra@Delete']);
        $router->get('/extra/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra@Selector']);
        //
        // EXTRA TRANSL
        //
        $router->post('/extraTransl',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra_Transl@Insert']);
        $router->put('/extraTransl',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra_Transl@Update']);
        $router->delete('/extraTransl/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra_Transl@Delete']);
        $router->get('/extraTransl/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra_Transl@Index']);
        $router->get('/extra/{Id_Extra}/extraTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Extra_Transl@List']);


        //endregion

        //region TABLAS DE EQUIPOS

        //
        // EQUIPMENT
        //
        $router->post('/equipment',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment@Insert']);
        $router->put('/equipment',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment@Update']);
        $router->delete(
            '/equipment/{Id}',
            [
                'middleware' => 'Auth_Owner',
                'uses' => 'c_Equipment@Delete'
            ]
        );
        $router->get('/equipment/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment@Selector']);
        $router->get('/equipment/{Action}/bookingTour', ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment@ListBookingTour']);
        //
        // EQUIPMENT RATE
        //
        $router->post('/equipmentRate',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Rate@Insert']);
        $router->put('/equipmentRate',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Rate@Update']);
        $router->delete('/equipmentRate/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Rate@Delete']);
        $router->get('/equipmentRate/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Rate@Index']);
        $router->get('/equipment/{Id_Equipment}/equipmentRate', ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Rate@List']);
        //
        // EQUIPMENT TRANSL
        //
        $router->post('/equipmentTransl',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Transl@Insert']);
        $router->put('/equipmentTransl',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Transl@Update']);
        $router->delete('/equipmentTransl/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Transl@Delete']);
        $router->get('/equipmentTransl/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Transl@Index']);
        $router->get('/equipment/{Id_Equipment}/equipmentTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Equipment_Transl@List']);


        $router->get('/upgrade_extra_equipment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_UpgradeExtraEquipment@List']);
        //endregion

        //region TABLAS DE TOUR

        //
        // TOUR
        //
        $router->post('/tour', ['middleware' => 'Auth_Owner', 'uses' => 'Tour\\TourInsertController@__invoke']);
        $router->put('/tour', ['middleware' => 'Auth_Owner', 'uses' => 'Tour\\TourUpdateController@__invoke']);
        $router->delete('/tour/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour@Delete']);
        $router->get('/tour/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour@selector']);
        $router->get('/tourAvailability', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour@Availability']);
        $router->get('/tourCategory/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour@ListCategory']);

        include __DIR__ . '/owner/tour.php';

        //
        // TOUR LOCK
        //
        include __DIR__ . '/owner/tourLock.php';


        //
        // TOUR TRANSL
        //
        $router->post('/tourTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Transl@Insert']);
        $router->put('/tourTransl',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Transl@Update']);
        $router->delete('/tourTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Transl@Delete']);
        $router->get('/tourTransl/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Transl@Index']);
        $router->get('/tour/{Id_Tour}/tourTransl',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Transl@List']);
        //
        // TOUR ACTIVITY
        //
        $router->post('/tourActivity',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity@Insert']);
        $router->put('/tourActivity',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity@Update']);
        $router->delete('/tourActivity/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity@Delete']);
        $router->get('/tourActivity/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity@Index']);
        $router->get('/tour/{Id_Tour}/tourActivity', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity@List']);

        //
        // TOUR ACTIVITY DETAIL
        //
        $router->post('/tourActivityDetail',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity_Detail@Insert']);
        $router->put('/tourActivityDetail',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity_Detail@Update']);
        $router->delete('/tourActivityDetail/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity_Detail@Delete']);
        $router->get('/tourActivityDetail/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity_Detail@Index']);
        $router->get('/tourActivity/{Id_TourActivity}/tourActivityDetail',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Activity_Detail@List']);
        //
        // TOUR QUESTION
        //
        $router->post('/tourQuestion',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@Insert']);
        $router->put('/tourQuestion',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@Update']);
        $router->delete('/tourQuestion/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@Delete']);
        $router->get('/tourQuestion/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@Index']);
        $router->get('/tour/{Id_Tour}/tourQuestion', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@List']);
        $router->get('/tour/{Id_Tour}/tourQuestion/translated', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Question@ListTranslated']);
        $router->put('/tourQuestion/copyQuestions', ['middleware' => 'Auth_Owner', 'uses' => 'Tour\\CopyQuestions@__invoke']);
        //
        // TOUR ITEM
        //
        $router->post('/tourItem',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Item@Insert']);
        $router->put('/tourItem',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Item@Update']);
        $router->delete('/tourItem/{Id}',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Item@Delete']);
        $router->get('/tourItem/{Id}',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Item@Index']);
        $router->get('/tour/{Id_Tour}/tourItem',    ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Item@List']);


        //
        // TOUR UPGRADE TYPE
        //
        $router->post('/tourUpgradeType',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade_Type@Insert']);
        $router->put('/tourUpgradeType',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade_Type@Update']);
        $router->delete('/tourUpgradeType/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade_Type@Delete']);
        $router->get('/tourUpgradeType/{Id}',       ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade_Type@Index']);
        $router->get('/tour/{Id_Tour}/tourUpgradeType/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade_Type@List']);
        //
        // TOUR UPGRADE
        //
        $router->post('/tourUpgrade',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade@Insert']);
        $router->put('/tourUpgrade',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade@Update']);
        $router->delete('/tourUpgrade/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade@Delete']);
        $router->get('/tourUpgrade/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade@Index']);
        $router->get('/tourUpgradeType/{Id_TourUpgradeType}/tourUpgrade/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Upgrade@List']);


        //
        // TOUR EXTRA TYPE
        //
        $router->post('/tourExtraType',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra_Type@Insert']);
        $router->put('/tourExtraType',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra_Type@Update']);
        $router->delete('/tourExtraType/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra_Type@Delete']);
        $router->get('/tourExtraType/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra_Type@Index']);
        $router->get('/tour/{Id_Tour}/tourExtraType/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra_Type@List']);
        //
        // TOUR EXTRA
        //
        $router->post('/tourExtra',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra@Insert']);
        $router->put('/tourExtra',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra@Update']);
        $router->delete('/tourExtra/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra@Delete']);
        $router->get('/tourExtra/{Id}',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra@Index']);
        $router->get('/tourExtraType/{Id_TourExtraType}/tourExtra/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Extra@List']);


        //
        // TOUR EQUIPMENT TYPE
        //
        $router->post('/tourEquipmentType',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment_Type@Insert']);
        $router->put('/tourEquipmentType',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment_Type@Update']);
        $router->delete('/tourEquipmentType/{Id}',     ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment_Type@Delete']);
        $router->get('/tourEquipmentType/{Id}',     ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment_Type@Index']);
        $router->get('/tour/{Id_Tour}/tourEquipmentType/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment_Type@List']);
        //
        // TOUR EQUIPMENT
        //
        $router->post('/tourEquipment',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment@Insert']);
        $router->put('/tourEquipment',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment@Update']);
        $router->delete('/tourEquipment/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment@Delete']);
        $router->get('/tourEquipment/{Id}',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment@Index']);
        $router->get('/tourEquipmentType/{Id_TourEquipmentType}/tourEquipment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Tour_Equipment@List']);

        //endregion

        //region TABLAS DE PAQUETES

        //
        // PACKAGE
        //

        include('owner/package.php');
        $router->post('/package',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Package@Insert']);
        $router->put('/package',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Package@Update']);
        $router->delete('/package/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package@Delete']);
        $router->get('/package/{Id}',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package@Selector']);
        $router->get('/packageBooking',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Package@IndexBooking']);
        $router->get('/calendarDays', ['uses' => 'c_Package@calendarDays']);
        //
        // PACKAGE TRANSL
        //
        $router->post('/packageTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Transl@Insert']);
        $router->put('/packageTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Transl@Update']);
        $router->delete('/packageTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Transl@Delete']);
        $router->get('/packageTransl/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Transl@Index']);
        $router->get('/package/{Id_Package}/packageTransl', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Transl@List']);

        //
        // PACKAGE TOUR
        //
        $router->post('/packageTour',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour@Insert']);
        $router->put('/packageTour',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour@Update']);
        $router->delete('/packageTour/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour@Delete']);
        $router->get('/packageTour/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour@Index']);
        $router->get('/package/{Id_Package}/packageTour', ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour@List']);

        //
        // PACKAGE TOUR EQUIPMENT
        //
        $router->post('/packageTourEquipment',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Equipment@Insert']);
        $router->put('/packageTourEquipment',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Equipment@Update']);
        $router->delete('/packageTourEquipment/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Equipment@Delete']);
        $router->get('/packageTourEquipment/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Equipment@Index']);
        $router->get('/packageTour/{Id_PackageTour}/packageTourEquipment',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Equipment@List']);

        //
        // PACKAGE TOUR EXTRA
        //
        $router->post('/packageTourExtra',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Extra@Insert']);
        $router->put('/packageTourExtra',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Extra@Update']);
        $router->delete('/packageTourExtra/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Extra@Delete']);
        $router->get('/packageTourExtra/{Id}',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Extra@Index']);
        $router->get('/packageTour/{Id_PackageTour}/packageTourExtra',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Extra@List']);

        //
        // PACKAGE TOUR UPGRADE
        //
        $router->post('/packageTourUpgrade',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Upgrade@Insert']);
        $router->put('/packageTourUpgrade',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Upgrade@Update']);
        $router->delete('/packageTourUpgrade/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Upgrade@Delete']);
        $router->get('/packageTourUpgrade/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Upgrade@Index']);
        $router->get('/packageTour/{Id_PackageTour}/packageTourUpgrade',    ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Tour_Upgrade@List']);

        //
        // PACKAGE RATE
        //
        $router->post('/packageRate',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Rate@Insert']);
        $router->put('/packageRate',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Rate@Update']);
        $router->delete('/packageRate/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Rate@Delete']);
        $router->get('/packageRate/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Rate@Index']);
        $router->get('/package/{Id_Package}/packageRate/{Id}',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Package_Rate@List']);
        //
        // PACKAGE FEE
        //

        include __DIR__ . '/owner/packageFee.php';


        //endregion

        //region TABLAS DE USUARIO

        //
        // USER COUNTRY
        //
        $router->post('/userCountry',                ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Country@Insert']);
        $router->post('/userCountry/update',         ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Country@Update']);
        $router->delete('/userCountry/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Country@Delete']);
        $router->get('/userCountry/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Country@Selector']);

        include __DIR__ . '/owner/user.php';

        //
        // USER PACKAGE RATE
        //
        $router->post('/userPackageRate',                ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Package_Rate@Insert']);
        $router->put('/userPackageRate',                ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Package_Rate@Update']);
        $router->get('/userPackageRate/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Package_Rate@Index']);
        $router->get('/user/{Id_User}/packageRate',     ['middleware' => 'Auth_Owner', 'uses' => 'c_User_Package_Rate@List']);


        //endregion

        //region TABLAS DE RESERVAS

        //
        // BOOKING
        //

        include __DIR__ . '/owner/booking.php';
        include __DIR__ . '/owner/bookingReport.php';
        include __DIR__ . '/owner/paymentBooking.php';
        include __DIR__ . '/owner/bookingTour.php';
        include __DIR__ . '/owner/bookingPackage.php';

        // BOOKING TOUR ACTIVITY
        $router->post('/bookingActivity',                        ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@Insert']);
        $router->put('/bookingActivity',                        ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@Update']);
        $router->delete('/bookingActivity/{Id}',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@Delete']);
        $router->get('/bookingActivity/{Id}',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@Index']);
        $router->get('/bookingActivity/report/bible',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@Report']);
        $router->get('/bookingTour/{Id_BookingTour}/bookingActivity', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Activity@List']);

        //
        // BOOKING TOUR PASSENGER
        //
        include __DIR__ . '/owner/bookingTourPassenger.php';

        //
        // BOOKING UPGRADE
        //
        $router->post('/bookingUpgrade', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Upgrade@Insert']);
        $router->put('/bookingUpgrade', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Upgrade@Update']);
        $router->delete('/bookingUpgrade/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Upgrade@Delete']);
        $router->get('/bookingUpgrade/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Upgrade@Index']);
        $router->get('/bookingTour/{Id_BookingTour}/bookingUpgrade', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Upgrade@List']);
        //
        // BOOKING UPGRADE PASSENGER
        //
        include __DIR__ . '/owner/bookingUpgradePassenger.php';

        //
        // BOOKING EXTRA
        //
        $router->post('/bookingExtra', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Extra@Insert']);
        $router->put('/bookingExtra', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Extra@Update']);
        $router->delete('/bookingExtra/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Extra@Delete']);
        $router->get('/bookingExtra/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Extra@Index']);
        $router->get('/bookingTour/{Id_BookingTour}/bookingExtra', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Extra@List']);
        //
        // BOOKING EXTRA PASSENGER
        //
        include __DIR__ . '/owner/bookingExtraPassenger.php';



        //
        // BOOKING EQUIPMENT
        //
        $router->post('/bookingEquipment', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@Insert']);
        $router->put('/bookingEquipment', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@Update']);
        $router->delete('/bookingEquipment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@Delete']);
        $router->get('/bookingEquipment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@Index']);
        $router->get(
            '/bookingTour/{Id_BookingTour}/bookingEquipment/passengerList/{Action}',
            ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@PassengerList']
        )->where(['Id_BookingTour' => '[0-9]*']);
        $router->get(
            '/bookingTour/{Id_BookingTour}/bookingEquipment',
            ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment@List']
        );
        //
        // BOOKING UPGRADE EXTRA EQUIPMENT
        //
        $router->get('/bookingTour/{Id_BookingTour}/bookingAll', ['middleware' => 'Auth_Owner', 'uses' => 'BookingUpgradeExtraEquipment@List']);

        //
        // BOOKING EXTRA PASSENGER
        //
        $router->post('/bookingEquipmentPassenger/all', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Insert_All']);
        $router->put('/bookingEquipmentPassenger/all', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Update_All']);
        $router->post('/bookingEquipmentPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Insert']);
        $router->put('/bookingEquipmentPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Update']);
        $router->delete('/bookingEquipmentPassenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Delete']);
        $router->get('/bookingEquipmentPassenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@Index']);
        $router->get('/bookingEquipment/{Id_BookingEquipment}/bookingEquipmentPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Booking_Equipment_Passenger@List']);


        //endregion

        //region TABLAS DE PASAJEROS

        //
        // PASSENGER
        //
        $router->post('/passenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@Insert']);
        $router->post('/passenger/update', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@UpdateAll']);
        $router->post('/passenger/updateDocuments', ['middleware' => 'Auth_Owner', 'uses' => 'Passenger\\PassengerUpdateDocumentsController@__invoke']);
        $router->put('/passenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@Update']);
        $router->get('/passenger/searchReview', ['middleware' => 'Auth_Owner', 'uses' => 'Passenger\\SearchWithReview@__invoke']);
        $router->get('/passenger/searchReviewReport', ['middleware' => 'Auth_Owner', 'uses' => 'Passenger\\PassengerSearchWithReviewReport@__invoke']);
        $router->get('/passenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@Selector']);
        $router->get('/booking/{Id_Booking}/passenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@List']);
        $router->get('/booking/{Id_Booking}/bookingTour/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger@ListTour']);
        $router->get('/passenger/{Id_Passenger}/passengerReview', ['middleware' => 'Auth_Owner', 'uses' => 'c_Passenger_Review@List']);

        include 'owner/passenger.php';
        include 'owner/passengerReview.php';

        //endregion

        //region TABLAS DE HABITACIONES

        //
        // ROOM
        //
        $router->post('/room', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room@Insert']);
        $router->put('/room', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room@Update']);
        $router->delete('/room/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room@Delete']);
        $router->get('/room/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room@Index']);
        $router->get('/booking/{Id_Booking}/room', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room@List']);
        //
        // ROOM PASSENGER
        //
        $router->post('/roomPassenger/all', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@Insert_All']);
        $router->post('/roomPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@Insert']);
        $router->put('/roomPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@Update']);
        $router->delete('/roomPassenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@Delete']);
        $router->get('/roomPassenger/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@Index']);
        $router->get('/room/{Id_Room}/roomPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Room_Passenger@List']);

        //endregion 

        //region TABLAS DE VUELOS

        //
        // FLIGHT
        //
        $router->post('/flight',                         ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight@Insert']);
        $router->put('/flight',                         ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight@Update']);
        $router->delete('/flight/{Id}',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight@Delete']);
        $router->get('/flight/{Id}',                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight@Index']);
        $router->get('/booking/{Id_Booking}/flight',    ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight@List']);
        //
        // FLIGHT PASSENGER
        //
        $router->post('/flightPassenger/all',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@Insert_All']);
        $router->post('/flightPassenger',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@Insert']);
        $router->put('/flightPassenger',                ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@Update']);
        $router->delete('/flightPassenger/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@Delete']);
        $router->get('/flightPassenger/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@Index']);
        $router->get('/flight/{Id_Flight}/flightPassenger', ['middleware' => 'Auth_Owner', 'uses' => 'c_Flight_Passenger@List']);

        //endregion 

        //region TABLAS DE INVOICE

        //
        //  INVOICE
        //
        $router->get('/booking/{Id}/invoice',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice@List']);

        $router->get('/invoice/excel',                      ['uses' => 'c_Invoice@reportExcel']);
        $router->get('/invoice/{Id}',                       ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice@GetReport']);
        $router->get('/invoiceReport',                  ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice@GetReportAll']);

        //
        //  INVOICE DETAIL
        //
        $router->post('/invoiceDetail',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@Insert']);
        $router->post('/invoiceDetailAll',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@InsertAll']);
        $router->put('/invoiceDetail',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@Update']);
        $router->delete('/invoiceDetail/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@Delete']);
        $router->get('/invoice/{Id}/invoiceDetail',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@List']);
        $router->get('/invoiceDetailAll',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Detail@ListAll']);
        //
        // INVOICE FEE
        //
        $router->get('/invoice/{Id_Invoice}/invoiceFee',    ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Fee@List']);
        $router->get('/invoiceFeeAll',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Fee@ListAll']);
        //
        // INVOICE FEE DETAIL
        //
        $router->get('/invoiceFee/{Id_InvoiceFee}/invoiceFeeDetail', ['middleware' => 'Auth_Owner', 'uses' => 'c_Invoice_Fee_Detail@List']);
        //
        // CASH MOVEMENT
        //


        //
        //  CALENDAR
        //      
        $router->get('/calendarPax', ['uses' => 'Booking@CalendarPax']);
        $router->get('/calendarCategory', ['uses' => 'Booking\\BookingCalendarCategoryController@__invoke']);
        $router->get('/calendarCategoryPax', ['uses' => 'Booking@CalendarCategoryPaxs']);
        //endregion

        //region TABLA DE MOVIMIENTOS DE CAJA

        $router->get('/invoice/{Id_Invoice}/cashMovement', ['middleware' => 'Auth_Owner', 'uses' => 'CashMovement@list']);
        include __DIR__ . '/owner/cashMovement.php';
        $router->post('/cashMovement', ['middleware' => 'Auth_Owner', 'uses' => 'CashMovement@insert']);
        $router->post('/cashMovement/discount', ['middleware' => 'Auth_Owner', 'uses' => 'CashMovement@insertDiscount']);
        $router->get('/cashMovement/search/report', ['uses' => 'CashMovement@reportExcel']);
        $router->get('/cashMovement/reportOne/{Id}', ['uses' => 'CashMovement@reportExcelJustOne']);
        $router->get('/cashMovement/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'CashMovement@selector']);
        $router->get('/cashMovementAll', ['middleware' => 'Auth_Owner', 'uses' => 'CashMovement@listAll']);

        include __DIR__ . '/owner/redistribution.php';

        //endregion
        include __DIR__ . '/owner/cashMovementDetail.php';

        //region TABLAS DE GRUPOS

        //
        // GROUP
        //

        include __DIR__ . '/owner/group.php';
        include __DIR__ . '/owner/groupPassenger.php';

        //
        // GROUP PROVIDER
        //
        include __DIR__ . '/owner/groupProvider.php';

        //
        // GROUP EQUIPMENT
        //
        $router->post('/groupEquipment',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Equipment@Insert']);
        $router->put('/groupEquipment',             ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Equipment@Update']);
        $router->delete('/groupEquipment/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Equipment@Delete']);
        $router->get('/groupEquipment/{Id}',        ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Equipment@Index']);
        $router->get('/group/{Id_Group}/groupEquipment/{Id}', ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Equipment@List']);

        //
        //GROUP ACTIVITY
        //
        $router->post('/groupActivity',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@Insert']);
        $router->put('/groupActivity',                      ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@Update']);
        $router->delete('/groupActivity/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@Delete']);
        $router->get('/groupActivity/{Id}',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@Index']);
        $router->get('/groupActivity/report/bible',         ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@Report']);
        $router->get('/group/{Id_Group}/groupActivity',     ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity@List']);
        //
        // TOUR ACTIVITY DETAIL
        //
        $router->post('/groupActivityDetail',                                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity_Detail@Insert']);
        $router->put('/groupActivityDetail',                                    ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity_Detail@Update']);
        $router->delete('/groupActivityDetail/{Id}',                               ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity_Detail@Delete']);
        $router->get('/groupActivityDetail/{Id}',                               ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity_Detail@Index']);
        $router->get('/groupActivity/{Id_GroupActivity}/groupActivityDetail',   ['middleware' => 'Auth_Owner', 'uses' => 'c_Group_Activity_Detail@List']);
        //endregion

        //region NOTIFICATION

        //
        //  NOTIFICATION
        //
        $router->post('/notification/all',               ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@Insert_All']);
        $router->post('/notification',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@Insert']);
        $router->put('/notification/accept',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@Accept']);
        $router->delete('/notification/{Id}',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@Delete']);
        $router->get('/notification/report',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@report']);
        $router->get('/notification/{Id}',              ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@Index']);
        $router->get('/notification',                   ['middleware' => 'Auth_Owner', 'uses' => 'c_Notification@List']);

        //endregion

        //region LINKS DE PAGO

        //
        //  SCHEDULE
        //
        $router->post('/schedule',                       ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@Insert']);
        $router->put('/schedule',                       ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@Update']);
        $router->delete('/schedule/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@Delete']);
        $router->get('/schedule/{Id}',                  ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@Index']);
        $router->get('/schedule/search/{Schedule_Token}',       ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@Search']);
        $router->get('/booking/{Id_Booking}/schedule',  ['middleware' => 'Auth_Owner', 'uses' => 'Schedule@List']);

        //
        //  SCHEDULE DETAIL
        //
        $router->post('/scheduleDetail',                 ['middleware' => 'Auth_Owner', 'uses' => 'c_Schedule_Detail@Insert']);
        $router->put('/scheduleDetail/update',          ['middleware' => 'Auth_Owner', 'uses' => 'c_Schedule_Detail@Update']);
        $router->delete('/scheduleDetail/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Schedule_Detail@Delete']);
        $router->get('/scheduleDetail/{Id}',            ['middleware' => 'Auth_Owner', 'uses' => 'c_Schedule_Detail@Index']);
        $router->get('/schedule/{Id_Schedule}/scheduleDetail',  ['middleware' => 'Auth_Owner', 'uses' => 'c_Schedule_Detail@List']);

        //endregion

        //region Booking Relationship

        $router->post('/bookingRelationship',                ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingRelationship@Insert']);
        $router->put('/bookingRelationship',                ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingRelationship@Update']);
        $router->delete('/bookingRelationship/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingRelationship@Delete']);
        $router->get('/bookingRelationship/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingRelationship@Selector']);

        //endregion

        //region Booking ReferredFrom

        $router->post('/bookingReferredFrom',                ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingReferredFrom@Insert']);
        $router->put('/bookingReferredFrom',                ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingReferredFrom@Update']);
        $router->delete('/bookingReferredFrom/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingReferredFrom@Delete']);
        $router->get('/bookingReferredFrom/{Id}',           ['middleware' => 'Auth_Owner', 'uses' => 'c_BookingReferredFrom@Selector']);

        //endregion

        include __DIR__ . '/owner/htlCamp.php';
        include __DIR__ . '/owner/htlRoom.php';
        include __DIR__ . '/owner/htlUsage.php';
        include __DIR__ . '/owner/tourHtlCamp.php';
        include __DIR__ . '/owner/paxInformation.php';
        include __DIR__ . '/owner/paxInformationPassenger.php';
        include __DIR__ . '/owner/info.php';
        include __DIR__ . '/owner/moduleNotification.php';
        include __DIR__ . '/owner/reviewDetail.php';
        include __DIR__ . '/owner/external.php';
        include __DIR__ . '/owner/externalUser.php';
        include __DIR__ . '/owner/externalUserPassenger.php';
        include __DIR__ . '/owner/externalReview.php';
        include __DIR__ . '/owner/externalReviewProvider.php';
        include __DIR__ . '/owner/lead.php';
        include __DIR__ . '/owner/leadBooking.php';
        include __DIR__ . '/owner/leadPassenger.php';
        include __DIR__ . '/owner/leadBookingPackage.php';
        include __DIR__ . '/owner/leadBookingTour.php';
        include __DIR__ . '/owner/leadBookingTourPassenger.php';
        include __DIR__ . '/owner/leadBookingService.php';
        include __DIR__ . '/owner/leadBookingServicePassenger.php';
        include __DIR__ . '/owner/machupicchuAvailability.php';
        include __DIR__ . '/owner/reviewNotification.php';
        include __DIR__ . '/owner/bookingTourItem.php';
        include __DIR__ . '/owner/providerTypeProvider.php';
        include __DIR__ . '/owner/questionTypeProvider.php';
        include __DIR__ . '/owner/groupProviderReview.php';
        include __DIR__ . '/owner/bookingCalendar.php';
        include __DIR__ . '/owner/statusGroup.php';
        include __DIR__ . '/owner/statusGroupProvider.php';
        include __DIR__ . '/owner/calendarTour.php';
        include __DIR__ . '/owner/providerSanction.php';
        include __DIR__ . '/owner/batch.php';
        include __DIR__ . '/owner/typeBookingAssign.php';
        include __DIR__ . '/owner/bookingAssign.php';
        include __DIR__ . '/owner/webContact.php';
        include __DIR__ . '/owner/webContactMessage.php';
        include __DIR__ . '/owner/webContactMessageDetail.php';
        include __DIR__ . '/owner/factTypeDocument.php';
        include __DIR__ . '/owner/factTypeReceipt.php';
        include __DIR__ . '/owner/factTypeOperation.php';
        include __DIR__ . '/owner/factUnit.php';
        include __DIR__ . '/owner/factProduct.php';
        include __DIR__ . '/owner/factReceipt.php';
        include __DIR__ . '/owner/factReceiptDetail.php';
        include __DIR__ . '/owner/cashMovementFactReceipt.php';
        include __DIR__ . '/owner/bookingAdditional.php';
        include __DIR__ . '/owner/htlTypeCamp.php';
        include __DIR__ . '/owner/htlTypeRoom.php';
        include __DIR__ . '/owner/htlBed.php';
        include __DIR__ . '/owner/htlTypeRoomBed.php';
        include __DIR__ . '/owner/htlCampSchedule.php';
        include __DIR__ . '/owner/htlCampBooking.php';
        include __DIR__ . '/owner/htlCampBookingPassenger.php';
        include __DIR__ . '/owner/calendar.php';
        include __DIR__ . '/owner/briefing.php';
        include __DIR__ . '/owner/htlCampLock.php';
        include __DIR__ . '/owner/invoice.php';
        include __DIR__ . '/owner/credential.php';
        include __DIR__ . '/owner/externalApiRequest.php';
        include __DIR__ . '/owner/factPaymentMethod.php';
        include __DIR__ . '/owner/factCurrency.php';
        include __DIR__ . '/owner/tourQuestion.php';
        include __DIR__ . '/owner/history.php';
        include __DIR__ . '/owner/report/booking.php';
        include __DIR__ . '/owner/groupPassengerMedia.php';
        include __DIR__ . '/owner/groupProviderMedia.php';

        //
        // HISTORY
        //
        $router->get('/history', ['middleware' => 'Auth_Owner', 'uses' => 'c_History@List']);

        //endregion
    }
);

// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// //                                                                                                                           //
// //                                                    RUTAS API CLIENT                                                       //
// //                                                                                                                           //
// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Route::group(
    [
        "namespace" => "App\Http\Controllers\Client",
        "prefix"    => "client"
    ],
    function () use ($router, $app) {

        //region TABLAS DE SISTEMA

        //
        // LANGUAGE
        //
        $router->get('/language/{Id}',          ['middleware' => 'Auth_Client', 'uses' => 'c_Language@Index']);
        $router->get('/language',               ['middleware' => 'Auth_Client', 'uses' => 'c_Language@List']);

        //endregion

        //region TYPE DOCUMENT

        //
        //  TYPE DOCUMENT
        //
        $router->get('/typeDocument',                   ['uses' => 'TypeDocument@list']);

        //endregion

        include __DIR__ . '/client/package.php';

        //endregion

        //region CALENDAR

        //
        //  CALENDAR
        //      
        $router->get('/calendarPax',                    ['uses' => 'BookingTour@calendarPax']);
        //
        //  CALENDAR
        //      
        $router->get('/sendamail',                  ['uses' => 'c_Booking@SendMailTest']);

        //endregion

        //region BOOKING

        //
        // BOOKING
        //
        $router->post('/booking',                        ['uses' => 'c_Booking@Insert']);
        $router->get('/user/{Id_User}/booking',         ['middleware' => 'Auth_Client', 'uses' => 'c_Booking@List']);
        $router->get('/user/{Id_User}/booking/report',  ['middleware' => 'Auth_Client', 'uses' => 'c_Booking@Report']);
        $router->get('/user/{Id_User}/booking/{Id}',    ['middleware' => 'Auth_Client', 'uses' => 'c_Booking@Index']);
        $router->get('/user/{Id_User}/booking/{Id_Booking}/pdf',    ['middleware' => 'Auth_Client', 'uses' => 'c_Booking@ReportPdf']);
        $router->post('/booking/endorser',               ['middleware' => 'Auth_Client', 'uses' => 'c_Booking@InsertEndorser']);

        $router->get('/typePayment/{Id}',               ['middleware' => 'Auth_Client', 'uses' => 'c_Type_Payment@Selector']);

        //endregion

        //region INVOICE

        //
        //  INVOICE
        //
        $router->get('/invoice/{Id}',                   ['middleware' => 'Auth_Client', 'uses' => 'c_Invoice@Index']);
        $router->get('/invoice/{Id}/allInfo',           ['middleware' => 'Auth_Client', 'uses' => 'c_Invoice@AllInfo']);

        //
        //  PASSENGER
        //
        $router->post('/passenger',                      ['middleware' => 'Auth_Client',  'uses' => 'c_Passenger@Update']);
        $router->post('/passenger/{Booking_Token}/tokenized',            ['uses' => 'c_Passenger@TokenizedUpdate']);
        $router->get('/passenger/{Booking_Token}/tokenized/{Id}',       ['uses' => 'c_Passenger@TokenizedIndex']);
        $router->get('/passenger/{Id}',                 ['middleware' => 'Auth_Client', 'uses' => 'c_Passenger@Index']);
        $router->get('/passenger',                      ['uses' => 'c_Passenger@TokenizedList']);
        $router->get('/booking/{Id_Booking}/passenger', ['middleware' => 'Auth_Client', 'uses' => 'c_Passenger@List']);
        //
        //  PASSENGER REVIEW
        //
        $router->put('/passengerReview/{passengerReview}',        ['uses' => 'c_Passenger_Review@Update']);
        $router->get('/passengerReview/{Token}',        ['uses' => 'c_Passenger_Review@List']);

        //
        // PACKAGE FEE
        //
        $router->get('/packageFee/{Id}',                ['uses' => 'c_Package_Fee@List']);

        //
        // INVOICE FEE
        //
        $router->get('/invoice/{Id}/invoiceFee',        ['uses' => 'c_Invoice_Fee@List']);
        $router->get('/invoiceFee/{Id}',                ['uses' => 'c_Invoice_Fee@Index']);
        $router->post('/invoiceFeeDetail',               ['uses' => 'c_Invoice_Fee_Detail@Insert']);


        //endregion

        //region TABLAS DE USUARIOS

        //
        // USER
        //
        //$router->post     ('/user',                       [ 'uses' => 'c_User@Insert']);
        $router->put('/user',                       ['middleware' => 'Auth_Client', 'uses' => 'c_User@Update']);
        $router->put('/user/password',              ['middleware' => 'Auth_Client', 'uses' => 'c_User@Password']);
        $router->post('/user/recover',               ['uses' => 'c_User@Recover']);
        $router->get('/user/{Id}',                  ['middleware' => 'Auth_Client', 'uses' => 'c_User@Index']);
        $router->get('/user/mail/verification',     ['uses' => 'c_User@Verification']);

        //
        // USER SESSION
        //
        $router->post('/login',                      ['uses' => 'c_User_Session@Insert']);
        $router->post('/logout',                     ['middleware' => 'Auth_Client', 'uses' => 'c_User_Session@Delete']);

        //
        // USER COUNTRY
        //
        $router->get('/userCountry',                ['uses' => 'c_User_Country@List']);

        //endregion

        //region TABLAS DE HABITACIONES

        //
        // ROOM
        //
        $router->post('/room',                           ['middleware' => 'Auth_Client', 'uses' => 'c_Room@Insert']);
        $router->put('/room',                           ['middleware' => 'Auth_Client', 'uses' => 'c_Room@Update']);
        $router->delete('/room/{Id}',                      ['middleware' => 'Auth_Client', 'uses' => 'c_Room@Delete']);
        $router->get('/room/{Id}',                      ['middleware' => 'Auth_Client', 'uses' => 'c_Room@Index']);
        $router->get('/booking/{Id_Booking}/room',      ['middleware' => 'Auth_Client', 'uses' => 'c_Room@List']);
        //
        // ROOM PASSENGER
        //
        $router->post('/roomPassenger',                  ['middleware' => 'Auth_Client', 'uses' => 'c_Room_Passenger@Insert']);
        $router->put('/roomPassenger',                  ['middleware' => 'Auth_Client', 'uses' => 'c_Room_Passenger@Update']);
        $router->delete('/roomPassenger/{Id}',             ['middleware' => 'Auth_Client', 'uses' => 'c_Room_Passenger@Delete']);
        $router->get('/roomPassenger/{Id}',             ['middleware' => 'Auth_Client', 'uses' => 'c_Room_Passenger@Index']);
        $router->get('/room/{Id_Room}/roomPassenger',   ['middleware' => 'Auth_Client', 'uses' => 'c_Room_Passenger@List']);

        //endregion 

        //region TABLAS DE VUELOS
        //
        // FLIGHT
        //
        $router->post('/flight',                         ['middleware' => 'Auth_Client', 'uses' => 'c_Flight@Insert']);
        $router->put('/flight',                         ['middleware' => 'Auth_Client', 'uses' => 'c_Flight@Update']);
        $router->delete('/flight/{Id}',                    ['middleware' => 'Auth_Client', 'uses' => 'c_Flight@Delete']);
        $router->get('/flight/{Id}',                    ['middleware' => 'Auth_Client', 'uses' => 'c_Flight@Index']);
        $router->get('/booking/{Id_Booking}/flight',    ['middleware' => 'Auth_Client', 'uses' => 'c_Flight@List']);
        //
        // FLIGHT PASSENGER
        //
        $router->post('/flightPassenger',                ['middleware' => 'Auth_Client', 'uses' => 'c_Flight_Passenger@Insert']);
        $router->put('/flightPassenger',                ['middleware' => 'Auth_Client', 'uses' => 'c_Flight_Passenger@Update']);
        $router->delete('/flightPassenger/{Id}',           ['middleware' => 'Auth_Client', 'uses' => 'c_Flight_Passenger@Delete']);
        $router->get('/flightPassenger/{Id}',           ['middleware' => 'Auth_Client', 'uses' => 'c_Flight_Passenger@Index']);
        $router->get('/flight/{Id_Flight}/flightPassenger', ['middleware' => 'Auth_Client', 'uses' => 'c_Flight_Passenger@List']);

        //endregion 

        $router->post('/cashMovement',                   ['middleware' => 'Auth_Client', 'uses' => 'c_Cash_Movement@Insert']);
        //
        // CREDENTIALS
        //
        $router->get('/credential',                 ['uses' => 'c_Credential@List']);

        //region SCHEDULE

        $router->get('/schedule/search',                ['uses' => 'c_Schedule@Search']);
        $router->put('/schedule/pay',                   ['uses' => 'c_Schedule@Pay']);
        $router->get('/schedule/{Id_Schedule}/scheduleDetail',  ['uses' => 'c_Schedule_Detail@List']);

        $router->get('/cashMovement/{Id}',              ['uses' => 'c_Cash_Movement@Index']);

        $router->post('/niubiz',                             ['uses' => 'c_Niubiz@Insert']);
        $router->post('/cashMovementTemp',                   ['uses' => 'c_Cash_Movement_Temp@Insert']);
        $router->get('/cashMovementTemp/{Id}',              ['uses' => 'c_Cash_Movement_Temp@Index']);
        $router->post('/validateCashMovementTemp/{Id}',          ['uses' => 'c_Cash_Movement_Temp@ValidateCashMovement']);

        //endregion

        $router->get('/bookingTemp/{Id}',                   ['uses' => 'c_Booking_Temp@Index']);
        $router->post('/bookingTemp/{Id}',                   ['uses' => 'c_Booking_Temp@ValidateBooking']);

        include __DIR__ . '/client/paxInformation.php';
        include __DIR__ . '/client/paxInformationPassenger.php';
        include __DIR__ . '/client/webContactMessage.php';
        include __DIR__ . '/client/webContactMessageDetail.php';
    }
);
// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// //                                                                                                                           //
// //                                                    RUTAS API PASSENGER                                                    //
// //                                                                                                                           //
// ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Route::group(
    [
        "namespace" => "App\Http\Controllers\Passenger",
        "prefix"    => "passenger"
    ],
    function () use ($router, $app) {
        //region TYPE DOCUMENT

        //
        //  PASSENGER REVIEW
        //
        $router->put('/passengerReview', ['middleware' => 'Auth_Passenger', 'uses' => 'PassengerReview@update']);
        $router->get('/passengerReview', ['middleware' => 'Auth_Passenger', 'uses' => 'PassengerReview@list']);
        $router->get('/passengerReview/groupPassenger', ['uses' => 'PassengerReview@listByIdGroupPassenger']);
        $router->post('/passengerReview/reviewToken', ['uses' => 'PassengerReview@listByGroupToken']);
        //
        // USER SESSION
        //
        $router->post('/login', ['uses' => 'c_Passenger_Session@Insert']);
        $router->post('/logout', ['middleware' => 'Auth_Passenger', 'uses' => 'c_Passenger_Session@Delete']);
        //endregion
        include __DIR__ . '/passenger/group.php';
        include __DIR__ . '/passenger/reviewSession.php';
        include __DIR__ . '/passenger/groupProviderReview.php';
        include __DIR__ . '/passenger/groupProvider.php';
        include __DIR__ . '/passenger/groupProviderMedia.php';
        include __DIR__ . '/passenger/groupPassenger.php';
        include __DIR__ . '/passenger/groupPassengerMedia.php';
    }
);
