<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\User\Domain\UserRepository;
use App\Modules\User\Infraestructure\MysqlUserRepository;

$app->bind(UserRepository::class, fn($app) => $app->make(MysqlUserRepository::class));


$router->get(
    '/user/{Id}/booking/tour/excel',
    [
        'uses' => 'User\\UserBookingByTourExcelController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->post(
    '/user',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@Insert'
    ]
);

$router->put(
    '/user',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@Update'
    ]
);

$router->delete(
    '/user/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@Delete'
    ]
);

$router->get(
    '/user/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@Index'
    ]
);

$router->get(
    '/userList/{Id}/type/{Type}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@List'
    ]
);

$router->get(
    '/user/mail/verification',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'User@Verification'
    ]
);

